/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing.bc;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.xrpl.xrpl4j.codec.addresses.KeyType;
import org.xrpl.xrpl4j.crypto.ServerSecret;
import org.xrpl.xrpl4j.crypto.ServerSecretSupplier;
import org.xrpl.xrpl4j.crypto.keys.KeyPair;
import org.xrpl.xrpl4j.crypto.keys.Passphrase;
import org.xrpl.xrpl4j.crypto.keys.PrivateKey;
import org.xrpl.xrpl4j.crypto.keys.PrivateKeyReference;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.keys.Seed;
import org.xrpl.xrpl4j.crypto.keys.bc.BcKeyUtils;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.crypto.signing.SignatureService;
import org.xrpl.xrpl4j.crypto.signing.SignatureUtils;
import org.xrpl.xrpl4j.crypto.signing.SingleSignedTransaction;
import org.xrpl.xrpl4j.crypto.signing.bc.BcSignatureService;
import org.xrpl.xrpl4j.model.client.channels.UnsignedClaim;
import org.xrpl.xrpl4j.model.ledger.Attestation;
import org.xrpl.xrpl4j.model.transactions.Signer;
import org.xrpl.xrpl4j.model.transactions.Transaction;

public class BcDerivedKeySignatureService
implements SignatureService<PrivateKeyReference> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final LoadingCache<PrivateKeyReference, BcSingleKeyTransactionSigner> transactionSignerCache;
    private final ServerSecretSupplier serverSecretSupplier;
    private final BcSignatureService commonBcSignatureService;

    public BcDerivedKeySignatureService(ServerSecretSupplier serverSecretSupplier) {
        this(serverSecretSupplier, CaffeineSpec.parse((String)"maximumSize=10000,expireAfterWrite=30s"));
    }

    public BcDerivedKeySignatureService(ServerSecretSupplier serverSecretSupplier, CaffeineSpec caffeineSpec) {
        this.serverSecretSupplier = Objects.requireNonNull(serverSecretSupplier);
        this.transactionSignerCache = Caffeine.from((CaffeineSpec)Objects.requireNonNull(caffeineSpec)).build(this::constructTransactionSigner);
        this.commonBcSignatureService = new BcSignatureService(SignatureUtils.getInstance(), new Ed25519Signer(), new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest())));
    }

    @Override
    public PublicKey derivePublicKey(PrivateKeyReference privateKeyable) {
        Objects.requireNonNull(privateKeyable);
        return this.getTransactionSigner(privateKeyable).getPublicKey();
    }

    @Override
    public <T extends Transaction> SingleSignedTransaction<T> sign(PrivateKeyReference privateKeyReference, T transaction) {
        Objects.requireNonNull(privateKeyReference);
        Objects.requireNonNull(transaction);
        return this.getTransactionSigner(privateKeyReference).sign(transaction);
    }

    @Override
    public Signature sign(PrivateKeyReference privateKeyReference, UnsignedClaim unsignedClaim) {
        return this.getTransactionSigner(privateKeyReference).sign(unsignedClaim);
    }

    @Override
    public Signature sign(PrivateKeyReference privateKeyReference, Attestation attestation) {
        return this.getTransactionSigner(privateKeyReference).sign(attestation);
    }

    @Override
    public <T extends Transaction> Signature multiSign(PrivateKeyReference privateKeyReference, T transaction) {
        Objects.requireNonNull(privateKeyReference);
        Objects.requireNonNull(transaction);
        return this.getTransactionSigner(privateKeyReference).multiSign(transaction);
    }

    @Override
    public <T extends Transaction> boolean verify(Signer signer, T unsignedTransaction) {
        Objects.requireNonNull(signer);
        Objects.requireNonNull(unsignedTransaction);
        return this.commonBcSignatureService.verify(signer, unsignedTransaction);
    }

    @Override
    public <T extends Transaction> boolean verifyMultiSigned(Set<Signer> signerSet, T unsignedTransaction, int minSigners) {
        Objects.requireNonNull(signerSet);
        Objects.requireNonNull(unsignedTransaction);
        Preconditions.checkArgument((minSigners > 0 ? 1 : 0) != 0, (Object)"Valid multisigned transactions must have at least 1 signer");
        long numValidSignatures = signerSet.stream().map(signer -> this.commonBcSignatureService.verifyMultiSigned(Sets.newHashSet((Object[])new Signer[]{signer}), unsignedTransaction, 1)).filter($ -> $).count();
        return numValidSignatures >= (long)minSigners;
    }

    @VisibleForTesting
    protected BcSingleKeyTransactionSigner constructTransactionSigner(PrivateKeyReference privateKeyReference) {
        KeyPair keyPair;
        Objects.requireNonNull(privateKeyReference);
        if (KeyType.ED25519 == privateKeyReference.keyType()) {
            Seed seed = this.generateEd25519XrplSeed(privateKeyReference.keyIdentifier());
            keyPair = seed.deriveKeyPair();
        } else if (KeyType.SECP256K1 == privateKeyReference.keyType()) {
            Seed seed = this.generateSecp256k1Seed(privateKeyReference.keyIdentifier());
            keyPair = seed.deriveKeyPair();
        } else {
            throw new IllegalArgumentException("Invalid KeyType: " + (Object)((Object)privateKeyReference.keyType()));
        }
        return new BcSingleKeyTransactionSigner(keyPair.privateKey(), this.commonBcSignatureService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final Seed generateEd25519XrplSeed(String accountIdentifier) {
        Objects.requireNonNull(accountIdentifier);
        ServerSecret serverSecretBytes = (ServerSecret)this.serverSecretSupplier.get();
        byte[] passphraseBytes = EMPTY_BYTE_ARRAY;
        try {
            passphraseBytes = Hashing.hmacSha512((byte[])serverSecretBytes.value()).hashBytes(accountIdentifier.getBytes()).asBytes();
            Seed seed = Seed.ed25519SeedFromPassphrase(Passphrase.of(passphraseBytes));
            return seed;
        }
        finally {
            serverSecretBytes.destroy();
            Arrays.fill(passphraseBytes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final Seed generateSecp256k1Seed(String accountIdentifier) {
        Objects.requireNonNull(accountIdentifier);
        ServerSecret serverSecretBytes = (ServerSecret)this.serverSecretSupplier.get();
        byte[] passphraseBytes = EMPTY_BYTE_ARRAY;
        try {
            passphraseBytes = Hashing.hmacSha512((byte[])serverSecretBytes.value()).hashBytes(accountIdentifier.getBytes()).asBytes();
            Seed seed = Seed.secp256k1SeedFromPassphrase(Passphrase.of(passphraseBytes));
            return seed;
        }
        finally {
            serverSecretBytes.destroy();
            Arrays.fill(passphraseBytes, (byte)0);
        }
    }

    private BcSingleKeyTransactionSigner getTransactionSigner(PrivateKeyReference privateKeyReference) {
        Objects.requireNonNull(privateKeyReference);
        return (BcSingleKeyTransactionSigner)this.transactionSignerCache.get((Object)privateKeyReference);
    }

    private static class BcSingleKeyTransactionSigner {
        private final PrivateKey privateKey;
        private final BcSignatureService bcSignatureService;

        public BcSingleKeyTransactionSigner(PrivateKey privateKey, BcSignatureService bcSignatureService) {
            this.privateKey = Objects.requireNonNull(privateKey);
            this.bcSignatureService = Objects.requireNonNull(bcSignatureService);
        }

        public final <T extends Transaction> SingleSignedTransaction<T> sign(T transaction) {
            return this.bcSignatureService.sign(this.privateKey, transaction);
        }

        public Signature sign(UnsignedClaim unsignedClaim) {
            Objects.requireNonNull(unsignedClaim);
            return this.bcSignatureService.sign(this.privateKey, unsignedClaim);
        }

        public Signature sign(Attestation attestation) {
            Objects.requireNonNull(attestation);
            return this.bcSignatureService.sign(this.privateKey, attestation);
        }

        public <T extends Transaction> Signature multiSign(T transaction) {
            return this.bcSignatureService.multiSign(this.privateKey, transaction);
        }

        public PublicKey getPublicKey() {
            return BcKeyUtils.toPublicKey(this.privateKey);
        }
    }
}

