/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.xrpl.xrpl4j.crypto.keys.PrivateKeyable;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.crypto.signing.SingleSignedTransaction;
import org.xrpl.xrpl4j.model.client.channels.UnsignedClaim;
import org.xrpl.xrpl4j.model.ledger.Attestation;
import org.xrpl.xrpl4j.model.transactions.Signer;
import org.xrpl.xrpl4j.model.transactions.Transaction;

public interface TransactionSigner<P extends PrivateKeyable> {
    public PublicKey derivePublicKey(P var1);

    public <T extends Transaction> SingleSignedTransaction<T> sign(P var1, T var2);

    public Signature sign(P var1, UnsignedClaim var2);

    @Beta
    public Signature sign(P var1, Attestation var2);

    public <T extends Transaction> Signature multiSign(P var1, T var2);

    default public <T extends Transaction> Signer multiSignToSigner(P privateKeyable, T transaction) {
        Objects.requireNonNull(privateKeyable);
        Objects.requireNonNull(transaction);
        PublicKey signingPublicKey = this.derivePublicKey(privateKeyable);
        return Signer.builder().account(signingPublicKey.deriveAddress()).signingPublicKey(signingPublicKey).transactionSignature(this.multiSign(privateKeyable, transaction)).build();
    }
}

