/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.Arrays;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.XrplBinaryCodec;
import org.xrpl.xrpl4j.model.jackson.ObjectMapperFactory;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;

public interface SignedTransaction<T extends Transaction> {
    public static final String SIGNED_TRANSACTION_HASH_PREFIX = "54584E00";

    public T unsignedTransaction();

    public T signedTransaction();

    @Value.Derived
    default public UnsignedByteArray signedTransactionBytes() {
        try {
            return UnsignedByteArray.fromHex(XrplBinaryCodec.getInstance().encode(ObjectMapperFactory.create().writeValueAsString(this.signedTransaction())));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Value.Derived
    default public Hash256 hash() {
        byte[] hashBytes = Arrays.copyOfRange(Hashing.sha512().hashBytes(BaseEncoding.base16().decode((CharSequence)SIGNED_TRANSACTION_HASH_PREFIX.concat(this.signedTransactionBytes().hexValue()).toUpperCase())).asBytes(), 0, 32);
        return Hash256.of(BaseEncoding.base16().encode(hashBytes));
    }
}

