/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.io.BaseEncoding;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.signing.ImmutableSignature;
import org.xrpl.xrpl4j.model.jackson.modules.SignatureDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.SignatureSerializer;

@JsonSerialize(as=ImmutableSignature.class, using=SignatureSerializer.class)
@JsonDeserialize(as=ImmutableSignature.class, using=SignatureDeserializer.class)
@Value.Immutable
public interface Signature {
    public static Signature of(UnsignedByteArray unsignedByteArray) {
        return Signature.builder().value(unsignedByteArray).build();
    }

    public static Signature fromBase16(String signatureBytesBase16) {
        return Signature.builder().value(UnsignedByteArray.fromHex(signatureBytesBase16)).build();
    }

    public static ImmutableSignature.Builder builder() {
        return ImmutableSignature.builder();
    }

    public UnsignedByteArray value();

    @JsonIgnore
    @Value.Lazy
    default public String base16Value() {
        return BaseEncoding.base16().encode(this.value().toByteArray());
    }

    @JsonIgnore
    @Value.Lazy
    default public String hexValue() {
        return this.base16Value();
    }
}

