/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.codec.addresses.AddressCodec;
import org.xrpl.xrpl4j.crypto.signing.ImmutableMultiSignedTransaction;
import org.xrpl.xrpl4j.crypto.signing.SignatureUtils;
import org.xrpl.xrpl4j.crypto.signing.SignedTransaction;
import org.xrpl.xrpl4j.model.transactions.Signer;
import org.xrpl.xrpl4j.model.transactions.SignerWrapper;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableMultiSignedTransaction.class)
@JsonDeserialize(as=ImmutableMultiSignedTransaction.class)
@Value.Immutable
public interface MultiSignedTransaction<T extends Transaction>
extends SignedTransaction<T> {
    public static <T extends Transaction> ImmutableMultiSignedTransaction.Builder<T> builder() {
        return ImmutableMultiSignedTransaction.builder();
    }

    public Set<Signer> signerSet();

    @Override
    @Value.Derived
    default public T signedTransaction() {
        List<SignerWrapper> signers = this.signerSet().stream().map(SignerWrapper::of).sorted(Comparator.comparing(signature -> new BigInteger(AddressCodec.getInstance().decodeAccountId(signature.signer().account()).hexValue(), 16))).collect(Collectors.toList());
        return SignatureUtils.getInstance().addMultiSignaturesToTransaction(this.unsignedTransaction(), signers);
    }
}

