/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.crypto.signing.SignedTransaction;
import org.xrpl.xrpl4j.crypto.signing.SingleSignedTransaction;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SingleSignedTransaction", generator="Immutables")
@Immutable
public final class ImmutableSingleSignedTransaction<T extends Transaction>
implements SingleSignedTransaction<T> {
    private final T unsignedTransaction;
    private final T signedTransaction;
    private final transient UnsignedByteArray signedTransactionBytes;
    private final transient Hash256 hash;
    private final Signature signature;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSingleSignedTransaction(T unsignedTransaction, T signedTransaction, Signature signature) {
        this.unsignedTransaction = unsignedTransaction;
        this.signedTransaction = signedTransaction;
        this.signature = signature;
        this.signedTransactionBytes = this.initShim.signedTransactionBytes();
        this.hash = this.initShim.hash();
        this.initShim = null;
    }

    private UnsignedByteArray signedTransactionBytesInitialize() {
        return SingleSignedTransaction.super.signedTransactionBytes();
    }

    private Hash256 hashInitialize() {
        return SingleSignedTransaction.super.hash();
    }

    @Override
    @JsonProperty(value="unsignedTransaction")
    public T unsignedTransaction() {
        return this.unsignedTransaction;
    }

    @Override
    @JsonProperty(value="signedTransaction")
    public T signedTransaction() {
        return this.signedTransaction;
    }

    @Override
    @JsonProperty(value="signedTransactionBytes")
    public UnsignedByteArray signedTransactionBytes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signedTransactionBytes() : this.signedTransactionBytes;
    }

    @Override
    @JsonProperty(value="hash")
    public Hash256 hash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hash() : this.hash;
    }

    @Override
    @JsonProperty(value="signature")
    public Signature signature() {
        return this.signature;
    }

    public final ImmutableSingleSignedTransaction<T> withUnsignedTransaction(T value) {
        if (this.unsignedTransaction == value) {
            return this;
        }
        Transaction newValue = (Transaction)Objects.requireNonNull(value, "unsignedTransaction");
        return new ImmutableSingleSignedTransaction<Transaction>(newValue, (Transaction)this.signedTransaction, this.signature);
    }

    public final ImmutableSingleSignedTransaction<T> withSignedTransaction(T value) {
        if (this.signedTransaction == value) {
            return this;
        }
        Transaction newValue = (Transaction)Objects.requireNonNull(value, "signedTransaction");
        return new ImmutableSingleSignedTransaction<Transaction>((Transaction)this.unsignedTransaction, newValue, this.signature);
    }

    public final ImmutableSingleSignedTransaction<T> withSignature(Signature value) {
        if (this.signature == value) {
            return this;
        }
        Signature newValue = Objects.requireNonNull(value, "signature");
        return new ImmutableSingleSignedTransaction<T>(this.unsignedTransaction, this.signedTransaction, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSingleSignedTransaction && this.equalTo(0, (ImmutableSingleSignedTransaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSingleSignedTransaction<?> another) {
        return this.unsignedTransaction.equals(another.unsignedTransaction) && this.signedTransaction.equals(another.signedTransaction) && this.signedTransactionBytes.equals(another.signedTransactionBytes) && this.hash.equals(another.hash) && this.signature.equals(another.signature);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.unsignedTransaction.hashCode();
        h += (h << 5) + this.signedTransaction.hashCode();
        h += (h << 5) + this.signedTransactionBytes.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.signature.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SingleSignedTransaction").omitNullValues().add("unsignedTransaction", this.unsignedTransaction).add("signedTransaction", this.signedTransaction).add("signedTransactionBytes", (Object)this.signedTransactionBytes).add("hash", (Object)this.hash).add("signature", (Object)this.signature).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends Transaction> ImmutableSingleSignedTransaction<T> fromJson(Json<T> json) {
        Builder builder = ImmutableSingleSignedTransaction.builder();
        if (json.unsignedTransaction != null) {
            builder.unsignedTransaction(json.unsignedTransaction);
        }
        if (json.signedTransaction != null) {
            builder.signedTransaction(json.signedTransaction);
        }
        if (json.signature != null) {
            builder.signature(json.signature);
        }
        return builder.build();
    }

    public static <T extends Transaction> ImmutableSingleSignedTransaction<T> copyOf(SingleSignedTransaction<T> instance) {
        if (instance instanceof ImmutableSingleSignedTransaction) {
            return (ImmutableSingleSignedTransaction)instance;
        }
        return ImmutableSingleSignedTransaction.builder().from(instance).build();
    }

    public static <T extends Transaction> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableSingleSignedTransaction(Transaction x0, Transaction x1, Signature x2, 1 x3) {
        this(x0, x1, x2);
    }

    @Generated(from="SingleSignedTransaction", generator="Immutables")
    private final class InitShim {
        private byte signedTransactionBytesBuildStage = 0;
        private UnsignedByteArray signedTransactionBytes;
        private byte hashBuildStage = 0;
        private Hash256 hash;

        private InitShim() {
        }

        UnsignedByteArray signedTransactionBytes() {
            if (this.signedTransactionBytesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signedTransactionBytesBuildStage == 0) {
                this.signedTransactionBytesBuildStage = (byte)-1;
                this.signedTransactionBytes = Objects.requireNonNull(ImmutableSingleSignedTransaction.this.signedTransactionBytesInitialize(), "signedTransactionBytes");
                this.signedTransactionBytesBuildStage = 1;
            }
            return this.signedTransactionBytes;
        }

        Hash256 hash() {
            if (this.hashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hashBuildStage == 0) {
                this.hashBuildStage = (byte)-1;
                this.hash = Objects.requireNonNull(ImmutableSingleSignedTransaction.this.hashInitialize(), "hash");
                this.hashBuildStage = 1;
            }
            return this.hash;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.signedTransactionBytesBuildStage == -1) {
                attributes.add("signedTransactionBytes");
            }
            if (this.hashBuildStage == -1) {
                attributes.add("hash");
            }
            return "Cannot build SingleSignedTransaction, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="SingleSignedTransaction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends Transaction> {
        private static final long INIT_BIT_UNSIGNED_TRANSACTION = 1L;
        private static final long INIT_BIT_SIGNED_TRANSACTION = 2L;
        private static final long INIT_BIT_SIGNATURE = 4L;
        private long initBits = 7L;
        @Nullable
        private T unsignedTransaction;
        @Nullable
        private T signedTransaction;
        @Nullable
        private Signature signature;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(SingleSignedTransaction<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(SignedTransaction<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SignedTransaction instance;
            long bits = 0L;
            if (object instanceof SingleSignedTransaction) {
                instance = (SingleSignedTransaction)object;
                if ((bits & 2L) == 0L) {
                    this.unsignedTransaction(instance.unsignedTransaction());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.signedTransaction(instance.signedTransaction());
                    bits |= 1L;
                }
                this.signature(instance.signature());
            }
            if (object instanceof SignedTransaction) {
                instance = (SignedTransaction)object;
                if ((bits & 2L) == 0L) {
                    this.unsignedTransaction(instance.unsignedTransaction());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.signedTransaction(instance.signedTransaction());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="unsignedTransaction")
        @CanIgnoreReturnValue
        public final Builder<T> unsignedTransaction(T unsignedTransaction) {
            this.unsignedTransaction = (Transaction)Objects.requireNonNull(unsignedTransaction, "unsignedTransaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="signedTransaction")
        @CanIgnoreReturnValue
        public final Builder<T> signedTransaction(T signedTransaction) {
            this.signedTransaction = (Transaction)Objects.requireNonNull(signedTransaction, "signedTransaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="signature")
        @CanIgnoreReturnValue
        public final Builder<T> signature(Signature signature) {
            this.signature = Objects.requireNonNull(signature, "signature");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSingleSignedTransaction<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSingleSignedTransaction((Transaction)this.unsignedTransaction, (Transaction)this.signedTransaction, this.signature, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("unsignedTransaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signedTransaction");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signature");
            }
            return "Cannot build SingleSignedTransaction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SingleSignedTransaction", generator="Immutables")
    static final class Json<T extends Transaction>
    implements SingleSignedTransaction<T> {
        @Nullable
        T unsignedTransaction;
        @Nullable
        T signedTransaction;
        @Nullable
        Signature signature;

        Json() {
        }

        @JsonProperty(value="unsignedTransaction")
        public void setUnsignedTransaction(T unsignedTransaction) {
            this.unsignedTransaction = unsignedTransaction;
        }

        @JsonProperty(value="signedTransaction")
        public void setSignedTransaction(T signedTransaction) {
            this.signedTransaction = signedTransaction;
        }

        @JsonProperty(value="signature")
        public void setSignature(Signature signature) {
            this.signature = signature;
        }

        @Override
        public T unsignedTransaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T signedTransaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public UnsignedByteArray signedTransactionBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Hash256 hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Signature signature() {
            throw new UnsupportedOperationException();
        }
    }
}

