/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.signing.Signature;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Signature", generator="Immutables")
@Immutable
public final class ImmutableSignature
implements Signature {
    private final UnsignedByteArray value;
    private volatile transient long lazyInitBitmap;
    private static final long BASE16_VALUE_LAZY_INIT_BIT = 1L;
    private transient String base16Value;
    private static final long HEX_VALUE_LAZY_INIT_BIT = 2L;
    private transient String hexValue;

    private ImmutableSignature(UnsignedByteArray value) {
        this.value = value;
    }

    @Override
    @JsonProperty(value="value")
    public UnsignedByteArray value() {
        return this.value;
    }

    public final ImmutableSignature withValue(UnsignedByteArray value) {
        if (this.value == value) {
            return this;
        }
        UnsignedByteArray newValue = Objects.requireNonNull(value, "value");
        return new ImmutableSignature(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignature && this.equalTo(0, (ImmutableSignature)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignature another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Signature").omitNullValues().add("value", (Object)this.value).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSignature fromJson(Json json) {
        Builder builder = ImmutableSignature.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String base16Value() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSignature immutableSignature = this;
            synchronized (immutableSignature) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.base16Value = Objects.requireNonNull(Signature.super.base16Value(), "base16Value");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.base16Value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hexValue() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableSignature immutableSignature = this;
            synchronized (immutableSignature) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.hexValue = Objects.requireNonNull(Signature.super.hexValue(), "hexValue");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.hexValue;
    }

    public static ImmutableSignature copyOf(Signature instance) {
        if (instance instanceof ImmutableSignature) {
            return (ImmutableSignature)instance;
        }
        return ImmutableSignature.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Signature", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private UnsignedByteArray value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Signature instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(UnsignedByteArray value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSignature build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignature(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Signature, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Signature", generator="Immutables")
    static final class Json
    implements Signature {
        @Nullable
        UnsignedByteArray value;

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(UnsignedByteArray value) {
            this.value = value;
        }

        @Override
        public UnsignedByteArray value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String base16Value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hexValue() {
            throw new UnsupportedOperationException();
        }
    }
}

