/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.signing.MultiSignedTransaction;
import org.xrpl.xrpl4j.crypto.signing.SignedTransaction;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Signer;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MultiSignedTransaction", generator="Immutables")
@Immutable
public final class ImmutableMultiSignedTransaction<T extends Transaction>
implements MultiSignedTransaction<T> {
    private final T unsignedTransaction;
    private final transient UnsignedByteArray signedTransactionBytes;
    private final transient Hash256 hash;
    private final ImmutableSet<Signer> signerSet;
    private final transient T signedTransaction;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMultiSignedTransaction(T unsignedTransaction, ImmutableSet<Signer> signerSet) {
        this.unsignedTransaction = unsignedTransaction;
        this.signerSet = signerSet;
        this.signedTransactionBytes = this.initShim.signedTransactionBytes();
        this.hash = this.initShim.hash();
        this.signedTransaction = this.initShim.signedTransaction();
        this.initShim = null;
    }

    private UnsignedByteArray signedTransactionBytesInitialize() {
        return MultiSignedTransaction.super.signedTransactionBytes();
    }

    private Hash256 hashInitialize() {
        return MultiSignedTransaction.super.hash();
    }

    private T signedTransactionInitialize() {
        return MultiSignedTransaction.super.signedTransaction();
    }

    @Override
    @JsonProperty(value="unsignedTransaction")
    public T unsignedTransaction() {
        return this.unsignedTransaction;
    }

    @Override
    @JsonProperty(value="signedTransactionBytes")
    public UnsignedByteArray signedTransactionBytes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signedTransactionBytes() : this.signedTransactionBytes;
    }

    @Override
    @JsonProperty(value="hash")
    public Hash256 hash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hash() : this.hash;
    }

    @JsonProperty(value="signerSet")
    public ImmutableSet<Signer> signerSet() {
        return this.signerSet;
    }

    @Override
    @JsonProperty(value="signedTransaction")
    public T signedTransaction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signedTransaction() : this.signedTransaction;
    }

    public final ImmutableMultiSignedTransaction<T> withUnsignedTransaction(T value) {
        if (this.unsignedTransaction == value) {
            return this;
        }
        Transaction newValue = (Transaction)Objects.requireNonNull(value, "unsignedTransaction");
        return new ImmutableMultiSignedTransaction<Transaction>(newValue, this.signerSet);
    }

    public final ImmutableMultiSignedTransaction<T> withSignerSet(Signer ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableMultiSignedTransaction<T>(this.unsignedTransaction, (ImmutableSet<Signer>)newValue);
    }

    public final ImmutableMultiSignedTransaction<T> withSignerSet(Iterable<? extends Signer> elements) {
        if (this.signerSet == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableMultiSignedTransaction<T>(this.unsignedTransaction, (ImmutableSet<Signer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiSignedTransaction && this.equalTo(0, (ImmutableMultiSignedTransaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableMultiSignedTransaction<?> another) {
        return this.unsignedTransaction.equals(another.unsignedTransaction) && this.signedTransactionBytes.equals(another.signedTransactionBytes) && this.hash.equals(another.hash) && this.signerSet.equals(another.signerSet) && this.signedTransaction.equals(another.signedTransaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.unsignedTransaction.hashCode();
        h += (h << 5) + this.signedTransactionBytes.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.signerSet.hashCode();
        h += (h << 5) + this.signedTransaction.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MultiSignedTransaction").omitNullValues().add("unsignedTransaction", this.unsignedTransaction).add("signedTransactionBytes", (Object)this.signedTransactionBytes).add("hash", (Object)this.hash).add("signerSet", this.signerSet).add("signedTransaction", this.signedTransaction).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends Transaction> ImmutableMultiSignedTransaction<T> fromJson(Json<T> json) {
        Builder builder = ImmutableMultiSignedTransaction.builder();
        if (json.unsignedTransaction != null) {
            builder.unsignedTransaction(json.unsignedTransaction);
        }
        if (json.signerSet != null) {
            builder.addAllSignerSet(json.signerSet);
        }
        return builder.build();
    }

    public static <T extends Transaction> ImmutableMultiSignedTransaction<T> copyOf(MultiSignedTransaction<T> instance) {
        if (instance instanceof ImmutableMultiSignedTransaction) {
            return (ImmutableMultiSignedTransaction)instance;
        }
        return ImmutableMultiSignedTransaction.builder().from(instance).build();
    }

    public static <T extends Transaction> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableMultiSignedTransaction(Transaction x0, ImmutableSet x1, 1 x2) {
        this(x0, (ImmutableSet<Signer>)x1);
    }

    @Generated(from="MultiSignedTransaction", generator="Immutables")
    private final class InitShim {
        private byte signedTransactionBytesBuildStage = 0;
        private UnsignedByteArray signedTransactionBytes;
        private byte hashBuildStage = 0;
        private Hash256 hash;
        private byte signedTransactionBuildStage = 0;
        private T signedTransaction;

        private InitShim() {
        }

        UnsignedByteArray signedTransactionBytes() {
            if (this.signedTransactionBytesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signedTransactionBytesBuildStage == 0) {
                this.signedTransactionBytesBuildStage = (byte)-1;
                this.signedTransactionBytes = Objects.requireNonNull(ImmutableMultiSignedTransaction.this.signedTransactionBytesInitialize(), "signedTransactionBytes");
                this.signedTransactionBytesBuildStage = 1;
            }
            return this.signedTransactionBytes;
        }

        Hash256 hash() {
            if (this.hashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hashBuildStage == 0) {
                this.hashBuildStage = (byte)-1;
                this.hash = Objects.requireNonNull(ImmutableMultiSignedTransaction.this.hashInitialize(), "hash");
                this.hashBuildStage = 1;
            }
            return this.hash;
        }

        T signedTransaction() {
            if (this.signedTransactionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signedTransactionBuildStage == 0) {
                this.signedTransactionBuildStage = (byte)-1;
                this.signedTransaction = Objects.requireNonNull(ImmutableMultiSignedTransaction.this.signedTransactionInitialize(), "signedTransaction");
                this.signedTransactionBuildStage = 1;
            }
            return this.signedTransaction;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.signedTransactionBytesBuildStage == -1) {
                attributes.add("signedTransactionBytes");
            }
            if (this.hashBuildStage == -1) {
                attributes.add("hash");
            }
            if (this.signedTransactionBuildStage == -1) {
                attributes.add("signedTransaction");
            }
            return "Cannot build MultiSignedTransaction, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="MultiSignedTransaction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends Transaction> {
        private static final long INIT_BIT_UNSIGNED_TRANSACTION = 1L;
        private long initBits = 1L;
        @Nullable
        private T unsignedTransaction;
        private ImmutableSet.Builder<Signer> signerSet = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(MultiSignedTransaction<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(SignedTransaction<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SignedTransaction instance;
            long bits = 0L;
            if (object instanceof MultiSignedTransaction) {
                instance = (MultiSignedTransaction)object;
                if ((bits & 1L) == 0L) {
                    this.unsignedTransaction(instance.unsignedTransaction());
                    bits |= 1L;
                }
                this.addAllSignerSet(instance.signerSet());
            }
            if (object instanceof SignedTransaction) {
                instance = (SignedTransaction)object;
                if ((bits & 1L) == 0L) {
                    this.unsignedTransaction(instance.unsignedTransaction());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="unsignedTransaction")
        @CanIgnoreReturnValue
        public final Builder<T> unsignedTransaction(T unsignedTransaction) {
            this.unsignedTransaction = (Transaction)Objects.requireNonNull(unsignedTransaction, "unsignedTransaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addSignerSet(Signer element) {
            this.signerSet.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addSignerSet(Signer ... elements) {
            this.signerSet.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="signerSet")
        @CanIgnoreReturnValue
        public final Builder<T> signerSet(Iterable<? extends Signer> elements) {
            this.signerSet = ImmutableSet.builder();
            return this.addAllSignerSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<T> addAllSignerSet(Iterable<? extends Signer> elements) {
            this.signerSet.addAll(elements);
            return this;
        }

        public ImmutableMultiSignedTransaction<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMultiSignedTransaction((Transaction)this.unsignedTransaction, this.signerSet.build(), null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("unsignedTransaction");
            }
            return "Cannot build MultiSignedTransaction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MultiSignedTransaction", generator="Immutables")
    static final class Json<T extends Transaction>
    implements MultiSignedTransaction<T> {
        @Nullable
        T unsignedTransaction;
        @Nullable
        Set<Signer> signerSet = ImmutableSet.of();

        Json() {
        }

        @JsonProperty(value="unsignedTransaction")
        public void setUnsignedTransaction(T unsignedTransaction) {
            this.unsignedTransaction = unsignedTransaction;
        }

        @JsonProperty(value="signerSet")
        public void setSignerSet(Set<Signer> signerSet) {
            this.signerSet = signerSet;
        }

        @Override
        public T unsignedTransaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public UnsignedByteArray signedTransactionBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Hash256 hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Signer> signerSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public T signedTransaction() {
            throw new UnsupportedOperationException();
        }
    }
}

