/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.crypto.signing.SignatureUtils;
import org.xrpl.xrpl4j.crypto.signing.TransactionVerifier;
import org.xrpl.xrpl4j.model.transactions.Signer;
import org.xrpl.xrpl4j.model.transactions.Transaction;

public abstract class AbstractTransactionVerifier
implements TransactionVerifier {
    private final SignatureUtils signatureUtils;

    public AbstractTransactionVerifier(SignatureUtils signatureUtils) {
        this.signatureUtils = Objects.requireNonNull(signatureUtils);
    }

    @Override
    public <T extends Transaction> boolean verify(Signer signer, T unsignedTransaction) {
        Objects.requireNonNull(signer);
        Objects.requireNonNull(unsignedTransaction);
        UnsignedByteArray transactionBytesUba = this.getSignatureUtils().toSignableBytes(unsignedTransaction);
        PublicKey publicKey = signer.signingPublicKey();
        switch (publicKey.keyType()) {
            case ED25519: {
                return this.edDsaVerify(publicKey, transactionBytesUba, signer.transactionSignature());
            }
            case SECP256K1: {
                return this.ecDsaVerify(publicKey, transactionBytesUba, signer.transactionSignature());
            }
        }
        throw new IllegalArgumentException("Unhandled PublicKey KeyType: {}" + (Object)((Object)publicKey.keyType()));
    }

    @Override
    public <T extends Transaction> boolean verifyMultiSigned(Set<Signer> signerSet, T unsignedTransaction, int minSigners) {
        Objects.requireNonNull(signerSet);
        Objects.requireNonNull(unsignedTransaction);
        Preconditions.checkArgument((minSigners > 0 ? 1 : 0) != 0);
        long numValidSignatures = signerSet.stream().map(signer -> {
            UnsignedByteArray unsignedTransactionBytes = this.getSignatureUtils().toMultiSignableBytes(unsignedTransaction, signer.signingPublicKey().deriveAddress());
            boolean oneValidSignature = this.verifyHelper((Signer)signer, unsignedTransactionBytes);
            return oneValidSignature;
        }).filter($ -> $).count();
        return numValidSignatures >= (long)minSigners;
    }

    private boolean verifyHelper(Signer signer, UnsignedByteArray unsignedTransactionBytes) {
        Objects.requireNonNull(signer);
        Objects.requireNonNull(unsignedTransactionBytes);
        PublicKey signerPublicKey = signer.signingPublicKey();
        Signature signerSignature = signer.transactionSignature();
        switch (signerPublicKey.keyType()) {
            case ED25519: {
                return this.edDsaVerify(signerPublicKey, unsignedTransactionBytes, signerSignature);
            }
            case SECP256K1: {
                return this.ecDsaVerify(signerPublicKey, unsignedTransactionBytes, signerSignature);
            }
        }
        throw new IllegalArgumentException("Unhandled PublicKey KeyType: {}" + (Object)((Object)signerPublicKey.keyType()));
    }

    protected abstract boolean edDsaVerify(PublicKey var1, UnsignedByteArray var2, Signature var3);

    protected abstract boolean ecDsaVerify(PublicKey var1, UnsignedByteArray var2, Signature var3);

    private SignatureUtils getSignatureUtils() {
        return this.signatureUtils;
    }
}

