/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import java.util.Objects;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.PrivateKeyable;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.crypto.signing.SignatureUtils;
import org.xrpl.xrpl4j.crypto.signing.SingleSignedTransaction;
import org.xrpl.xrpl4j.crypto.signing.TransactionSigner;
import org.xrpl.xrpl4j.model.client.channels.UnsignedClaim;
import org.xrpl.xrpl4j.model.ledger.Attestation;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Transaction;

public abstract class AbstractTransactionSigner<P extends PrivateKeyable>
implements TransactionSigner<P> {
    private final SignatureUtils signatureUtils;

    public AbstractTransactionSigner(SignatureUtils signatureUtils) {
        this.signatureUtils = Objects.requireNonNull(signatureUtils);
    }

    @Override
    public <T extends Transaction> SingleSignedTransaction<T> sign(P privateKeyable, T transaction) {
        Objects.requireNonNull(privateKeyable);
        Objects.requireNonNull(transaction);
        UnsignedByteArray signableTransactionBytes = this.signatureUtils.toSignableBytes(transaction);
        Signature signature = this.signingHelper(privateKeyable, signableTransactionBytes);
        return this.signatureUtils.addSignatureToTransaction(transaction, signature);
    }

    @Override
    public Signature sign(P privateKeyable, UnsignedClaim unsignedClaim) {
        Objects.requireNonNull(privateKeyable);
        Objects.requireNonNull(unsignedClaim);
        UnsignedByteArray signableBytes = this.signatureUtils.toSignableBytes(unsignedClaim);
        return this.signingHelper(privateKeyable, signableBytes);
    }

    @Override
    public Signature sign(P privateKeyable, Attestation attestation) {
        Objects.requireNonNull(privateKeyable);
        Objects.requireNonNull(attestation);
        UnsignedByteArray signableBytes = this.signatureUtils.toSignableBytes(attestation);
        return this.signingHelper(privateKeyable, signableBytes);
    }

    @Override
    public <T extends Transaction> Signature multiSign(P privateKeyable, T transaction) {
        Objects.requireNonNull(privateKeyable);
        Objects.requireNonNull(transaction);
        Address address = this.derivePublicKey(privateKeyable).deriveAddress();
        UnsignedByteArray signableTransactionBytes = this.signatureUtils.toMultiSignableBytes(transaction, address);
        return this.signingHelper(privateKeyable, signableTransactionBytes);
    }

    private Signature signingHelper(P privateKey, UnsignedByteArray signableTransactionBytes) {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(signableTransactionBytes);
        PublicKey publicKey = this.derivePublicKey(privateKey);
        switch (publicKey.keyType()) {
            case ED25519: {
                return this.edDsaSign(privateKey, signableTransactionBytes);
            }
            case SECP256K1: {
                return this.ecDsaSign(privateKey, signableTransactionBytes);
            }
        }
        throw new IllegalArgumentException("Unhandled PrivateKey KeyType: {}" + privateKey);
    }

    protected abstract Signature edDsaSign(P var1, UnsignedByteArray var2);

    protected abstract Signature ecDsaSign(P var1, UnsignedByteArray var2);
}

