/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Set;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.PrivateKeyable;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.AbstractTransactionSigner;
import org.xrpl.xrpl4j.crypto.signing.AbstractTransactionVerifier;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.crypto.signing.SignatureService;
import org.xrpl.xrpl4j.crypto.signing.SignatureUtils;
import org.xrpl.xrpl4j.crypto.signing.SingleSignedTransaction;
import org.xrpl.xrpl4j.model.client.channels.UnsignedClaim;
import org.xrpl.xrpl4j.model.ledger.Attestation;
import org.xrpl.xrpl4j.model.transactions.Signer;
import org.xrpl.xrpl4j.model.transactions.Transaction;

public abstract class AbstractSignatureService<P extends PrivateKeyable>
implements SignatureService<P> {
    private final AbstractTransactionSigner<P> abstractTransactionSigner;
    private final AbstractTransactionVerifier abstractTransactionVerifier;

    public AbstractSignatureService(SignatureUtils signatureUtils) {
        this.abstractTransactionSigner = new AbstractTransactionSigner<P>(signatureUtils){

            @Override
            protected Signature edDsaSign(P privateKey, UnsignedByteArray signableTransactionBytes) {
                return AbstractSignatureService.this.edDsaSign(privateKey, signableTransactionBytes);
            }

            @Override
            protected Signature ecDsaSign(P privateKey, UnsignedByteArray signableTransactionBytes) {
                return AbstractSignatureService.this.ecDsaSign(privateKey, signableTransactionBytes);
            }

            @Override
            public PublicKey derivePublicKey(P privateKey) {
                return AbstractSignatureService.this.derivePublicKey(privateKey);
            }
        };
        this.abstractTransactionVerifier = new AbstractTransactionVerifier(signatureUtils){

            @Override
            protected boolean edDsaVerify(PublicKey publicKey, UnsignedByteArray transactionBytes, Signature signature) {
                return AbstractSignatureService.this.edDsaVerify(publicKey, transactionBytes, signature);
            }

            @Override
            protected boolean ecDsaVerify(PublicKey publicKey, UnsignedByteArray transactionBytes, Signature signature) {
                return AbstractSignatureService.this.ecDsaVerify(publicKey, transactionBytes, signature);
            }
        };
    }

    @VisibleForTesting
    protected AbstractSignatureService(AbstractTransactionSigner<P> abstractTransactionSigner, AbstractTransactionVerifier abstractTransactionVerifier) {
        this.abstractTransactionSigner = Objects.requireNonNull(abstractTransactionSigner);
        this.abstractTransactionVerifier = Objects.requireNonNull(abstractTransactionVerifier);
    }

    @Override
    public <T extends Transaction> SingleSignedTransaction<T> sign(P privateKeyable, T transaction) {
        return this.abstractTransactionSigner.sign(privateKeyable, transaction);
    }

    @Override
    public Signature sign(P privateKeyable, UnsignedClaim unsignedClaim) {
        return this.abstractTransactionSigner.sign(privateKeyable, unsignedClaim);
    }

    @Override
    public Signature sign(P privateKeyable, Attestation attestation) {
        return this.abstractTransactionSigner.sign(privateKeyable, attestation);
    }

    @Override
    public <T extends Transaction> Signature multiSign(P privateKeyable, T transaction) {
        return this.abstractTransactionSigner.multiSign(privateKeyable, transaction);
    }

    @Override
    public <T extends Transaction> boolean verify(Signer signer, T unsignedTransaction) {
        return this.abstractTransactionVerifier.verify(signer, unsignedTransaction);
    }

    @Override
    public <T extends Transaction> boolean verifyMultiSigned(Set<Signer> signerSet, T unsignedTransaction, int minSigners) {
        return this.abstractTransactionVerifier.verifyMultiSigned(signerSet, unsignedTransaction, minSigners);
    }

    protected abstract Signature edDsaSign(P var1, UnsignedByteArray var2);

    protected abstract Signature ecDsaSign(P var1, UnsignedByteArray var2);

    protected abstract boolean edDsaVerify(PublicKey var1, UnsignedByteArray var2, Signature var3);

    protected abstract boolean ecDsaVerify(PublicKey var1, UnsignedByteArray var2, Signature var3);

    @Override
    public abstract PublicKey derivePublicKey(P var1);
}

