/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys.bc;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.xrpl.xrpl4j.codec.addresses.KeyType;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.PrivateKey;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.signing.bc.Secp256k1;

public final class BcKeyUtils {
    private static final String SECP256K1 = "secp256k1";
    private static final ECNamedCurveParameterSpec EC_PARAMS;
    public static final ECDomainParameters PARAMS;

    private BcKeyUtils() {
    }

    public static PrivateKey toPrivateKey(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters) {
        Objects.requireNonNull(ed25519PrivateKeyParameters);
        return PrivateKey.fromNaturalBytes(UnsignedByteArray.of(ed25519PrivateKeyParameters.getEncoded()), KeyType.ED25519);
    }

    public static PrivateKey toPrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        return PrivateKey.fromPrefixedBytes(Secp256k1.toUnsignedByteArray(ecPrivateKeyParameters.getD(), 33));
    }

    public static Ed25519PublicKeyParameters toEd25519PublicKeyParameters(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        Preconditions.checkArgument((publicKey.keyType() == KeyType.ED25519 ? 1 : 0) != 0);
        byte[] bytes = publicKey.value().toByteArray();
        Preconditions.checkArgument((bytes.length == 33 ? 1 : 0) != 0);
        byte[] truncatedBytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        return new Ed25519PublicKeyParameters(truncatedBytes, 0);
    }

    public static PublicKey toPublicKey(Ed25519PublicKeyParameters ed25519PublicKeyParameters) {
        Objects.requireNonNull(ed25519PublicKeyParameters);
        UnsignedByteArray prefixedPublicKey = UnsignedByteArray.of(PublicKey.ED2559_PREFIX, new UnsignedByte[0]).append(UnsignedByteArray.of(ed25519PublicKeyParameters.getEncoded()));
        return PublicKey.builder().value(prefixedPublicKey).build();
    }

    public static PublicKey toPublicKey(ECPublicKeyParameters ecPublicKeyParameters) {
        Objects.requireNonNull(ecPublicKeyParameters);
        byte[] encodedPublicKey = ecPublicKeyParameters.getQ().getEncoded(true);
        return PublicKey.builder().value(UnsignedByteArray.of(encodedPublicKey)).build();
    }

    public static ECPublicKeyParameters toPublicKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        Objects.requireNonNull(ecPrivateKeyParameters);
        ECPoint ecPoint = PARAMS.getG().multiply(ecPrivateKeyParameters.getD());
        return new ECPublicKeyParameters(ecPoint, PARAMS);
    }

    public static PublicKey toPublicKey(PrivateKey privateKey) {
        Objects.requireNonNull(privateKey);
        if (privateKey.keyType() == KeyType.ED25519) {
            Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = BcKeyUtils.toEd25519PrivateKeyParams(privateKey);
            return BcKeyUtils.toPublicKey(ed25519PrivateKeyParameters.generatePublicKey());
        }
        if (privateKey.keyType() == KeyType.SECP256K1) {
            ECPrivateKeyParameters ecPrivateKeyParameters = BcKeyUtils.toEcPrivateKeyParams(privateKey);
            ECPublicKeyParameters ecPublicKeyParameters = BcKeyUtils.toPublicKey(ecPrivateKeyParameters);
            return BcKeyUtils.toPublicKey(ecPublicKeyParameters);
        }
        throw new IllegalArgumentException("Invalid KeyType: " + (Object)((Object)privateKey.keyType()));
    }

    public static Ed25519PrivateKeyParameters toEd25519PrivateKeyParams(PrivateKey privateKey) {
        Objects.requireNonNull(privateKey);
        Preconditions.checkArgument((privateKey.keyType() == KeyType.ED25519 ? 1 : 0) != 0);
        return new Ed25519PrivateKeyParameters(privateKey.naturalBytes().toByteArray(), 0);
    }

    public static ECPublicKeyParameters toEcPublicKeyParameters(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        Preconditions.checkArgument((publicKey.keyType() == KeyType.SECP256K1 ? 1 : 0) != 0);
        ECPoint ecPoint = PARAMS.getCurve().decodePoint(publicKey.value().toByteArray());
        return new ECPublicKeyParameters(ecPoint, PARAMS);
    }

    public static ECPrivateKeyParameters toEcPrivateKeyParams(PrivateKey privateKey) {
        Objects.requireNonNull(privateKey);
        Preconditions.checkArgument((privateKey.keyType() == KeyType.SECP256K1 ? 1 : 0) != 0, (Object)"KeyType must be SECP256K1");
        BigInteger secretKeyD = new BigInteger(1, privateKey.naturalBytes().toByteArray());
        return new ECPrivateKeyParameters(secretKeyD, PARAMS);
    }

    static {
        BouncyCastleProvider bcProvider;
        EC_PARAMS = ECNamedCurveTable.getParameterSpec((String)SECP256K1);
        PARAMS = new ECDomainParameters(EC_PARAMS.getCurve(), EC_PARAMS.getG(), EC_PARAMS.getN(), EC_PARAMS.getH());
        if (Security.getProvider("BC") == null && Security.addProvider((Provider)(bcProvider = new BouncyCastleProvider())) == -1) {
            throw new RuntimeException("Could not configure BouncyCastle provider");
        }
    }
}

