/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.Objects;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.codec.addresses.AddressCodec;
import org.xrpl.xrpl4j.codec.addresses.KeyType;
import org.xrpl.xrpl4j.codec.addresses.PublicKeyCodec;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.ImmutablePublicKey;
import org.xrpl.xrpl4j.model.jackson.modules.PublicKeyDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.PublicKeySerializer;
import org.xrpl.xrpl4j.model.transactions.Address;

@JsonSerialize(as=ImmutablePublicKey.class, using=PublicKeySerializer.class)
@JsonDeserialize(as=ImmutablePublicKey.class, using=PublicKeyDeserializer.class)
@Value.Immutable
public interface PublicKey {
    public static final UnsignedByte ED2559_PREFIX = UnsignedByte.of(237);
    public static final PublicKey MULTI_SIGN_PUBLIC_KEY = PublicKey.builder().value(UnsignedByteArray.empty()).build();

    public static ImmutablePublicKey.Builder builder() {
        return ImmutablePublicKey.builder();
    }

    public static PublicKey fromBase58EncodedPublicKey(String base58EncodedPublicKey) {
        Objects.requireNonNull(base58EncodedPublicKey);
        if (base58EncodedPublicKey.isEmpty()) {
            return MULTI_SIGN_PUBLIC_KEY;
        }
        return PublicKey.builder().value(PublicKeyCodec.getInstance().decodeAccountPublicKey(base58EncodedPublicKey)).build();
    }

    public static PublicKey fromBase16EncodedPublicKey(String base16EncodedPublicKey) {
        Objects.requireNonNull(base16EncodedPublicKey);
        if (base16EncodedPublicKey.isEmpty()) {
            return MULTI_SIGN_PUBLIC_KEY;
        }
        return PublicKey.builder().value(UnsignedByteArray.of(BaseEncoding.base16().decode((CharSequence)base16EncodedPublicKey.toUpperCase()))).build();
    }

    public UnsignedByteArray value();

    @Value.Derived
    default public String base58Value() {
        if (this.value().length() == 0) {
            return "";
        }
        return PublicKeyCodec.getInstance().encodeAccountPublicKey(this.value());
    }

    @Value.Derived
    default public String base16Value() {
        return this.value().hexValue();
    }

    @Value.Derived
    default public KeyType keyType() {
        return this.base16Value().startsWith("ED") ? KeyType.ED25519 : KeyType.SECP256K1;
    }

    @Value.Lazy
    default public Address deriveAddress() {
        return AddressCodec.getInstance().encodeAccountId(PublicKey.computePublicKeyHash(this.value()));
    }

    public static UnsignedByteArray computePublicKeyHash(UnsignedByteArray publicKey) {
        Objects.requireNonNull(publicKey);
        byte[] sha256 = Hashing.sha256().hashBytes(publicKey.toByteArray()).asBytes();
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] ripemdSha256 = new byte[digest.getDigestSize()];
        digest.doFinal(ripemdSha256, 0);
        return UnsignedByteArray.of(ripemdSha256);
    }
}

