/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.security.auth.Destroyable;
import org.xrpl.xrpl4j.codec.addresses.KeyType;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.PrivateKeyable;

public class PrivateKey
implements PrivateKeyable,
Destroyable {
    @Deprecated
    public static final UnsignedByte PREFIX = UnsignedByte.of(237);
    public static final UnsignedByte ED2559_PREFIX = UnsignedByte.of(237);
    public static final UnsignedByte SECP256K1_PREFIX = UnsignedByte.of(0);
    private final UnsignedByteArray value;
    private final KeyType keyType;
    private boolean destroyed;

    public static PrivateKey fromNaturalBytes(UnsignedByteArray value, KeyType keyType) {
        return new PrivateKey(value, keyType);
    }

    public static PrivateKey fromPrefixedBytes(UnsignedByteArray value) {
        Objects.requireNonNull(value);
        Preconditions.checkArgument((value.length() == 33 ? 1 : 0) != 0, (Object)String.format("The `fromPrefixedBytes` function requires input length of 33 bytes, but %s were supplied.", value.length()));
        UnsignedByte prefixByte = value.get(0);
        if (ED2559_PREFIX.equals(prefixByte)) {
            return new PrivateKey(value.slice(1, 33), KeyType.ED25519);
        }
        if (SECP256K1_PREFIX.equals(prefixByte)) {
            return new PrivateKey(value.slice(1, 33), KeyType.SECP256K1);
        }
        throw new IllegalArgumentException(String.format("PrivateKey construction requires 32 natural bytes plug a one-byte prefix value of either `0xED` for ed25519 private keys or `0x00` for secp256k1 private keys. Input byte length was %s bytes with a prefixByte value of `0x%s`", value.length(), prefixByte.hexValue()));
    }

    @Deprecated
    public static PrivateKey of(UnsignedByteArray value) {
        return PrivateKey.fromPrefixedBytes(value);
    }

    private PrivateKey(UnsignedByteArray value, KeyType keyType) {
        Objects.requireNonNull(value);
        this.keyType = Objects.requireNonNull(keyType);
        Preconditions.checkArgument((value.length() == 32 ? 1 : 0) != 0, (Object)"Byte values passed to this constructor must be 32 bytes long, with no prefix.");
        this.value = UnsignedByteArray.of(value.toByteArray());
    }

    @Deprecated
    public UnsignedByteArray value() {
        if (this.value.length() == 0) {
            return UnsignedByteArray.empty();
        }
        return this.prefixedBytes();
    }

    public UnsignedByteArray naturalBytes() {
        if (this.value.length() == 0) {
            return UnsignedByteArray.empty();
        }
        return UnsignedByteArray.of(this.value.toByteArray());
    }

    public UnsignedByteArray prefixedBytes() {
        if (this.value.length() == 0) {
            return UnsignedByteArray.empty();
        }
        switch (this.keyType) {
            case ED25519: {
                return UnsignedByteArray.of(ED2559_PREFIX, new UnsignedByte[0]).append(this.naturalBytes());
            }
            case SECP256K1: {
                return UnsignedByteArray.of(SECP256K1_PREFIX, new UnsignedByte[0]).append(this.naturalBytes());
            }
        }
        throw new IllegalStateException(String.format("Invalid keyType=%s", new Object[]{this.keyType}));
    }

    @Override
    public final KeyType keyType() {
        return this.keyType;
    }

    @Override
    public final void destroy() {
        this.value.destroy();
        this.destroyed = true;
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrivateKey that = (PrivateKey)obj;
        return Objects.equals(this.value, that.value) && this.keyType == that.keyType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.keyType});
    }

    public String toString() {
        return String.format("PrivateKey{value=[redacted],keyType=%s,destroyed=%s}", new Object[]{this.keyType(), this.isDestroyed()});
    }
}

