/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Destroyable;

public class Passphrase
implements Destroyable {
    private final byte[] value;
    private boolean destroyed;

    public static Passphrase of(byte[] value) {
        return new Passphrase(value);
    }

    public static Passphrase of(String valueAsString) {
        return new Passphrase(valueAsString);
    }

    private Passphrase(String valueAsString) {
        this(valueAsString.getBytes(StandardCharsets.UTF_8));
    }

    private Passphrase(byte[] value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    public byte[] value() {
        byte[] copiedValue = new byte[this.value.length];
        System.arraycopy(this.value, 0, copiedValue, 0, this.value.length);
        return copiedValue;
    }

    @Override
    public final void destroy() {
        Arrays.fill(this.value, (byte)0);
        this.destroyed = true;
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Passphrase)) {
            return false;
        }
        Passphrase that = (Passphrase)obj;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return "Passphrase{value=[redacted], destroyed=" + this.destroyed + '}';
    }
}

