/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.KeyType;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PublicKey", generator="Immutables")
@Immutable
public final class ImmutablePublicKey
implements PublicKey {
    private final UnsignedByteArray value;
    private final transient String base58Value;
    private final transient String base16Value;
    private final transient KeyType keyType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long DERIVE_ADDRESS_LAZY_INIT_BIT = 1L;
    private transient Address deriveAddress;

    private ImmutablePublicKey(UnsignedByteArray value) {
        this.value = value;
        this.base58Value = this.initShim.base58Value();
        this.base16Value = this.initShim.base16Value();
        this.keyType = this.initShim.keyType();
        this.initShim = null;
    }

    private String base58ValueInitialize() {
        return PublicKey.super.base58Value();
    }

    private String base16ValueInitialize() {
        return PublicKey.super.base16Value();
    }

    private KeyType keyTypeInitialize() {
        return PublicKey.super.keyType();
    }

    @Override
    @JsonProperty(value="value")
    public UnsignedByteArray value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="base58Value")
    public String base58Value() {
        InitShim shim = this.initShim;
        return shim != null ? shim.base58Value() : this.base58Value;
    }

    @Override
    @JsonProperty(value="base16Value")
    public String base16Value() {
        InitShim shim = this.initShim;
        return shim != null ? shim.base16Value() : this.base16Value;
    }

    @Override
    @JsonProperty(value="keyType")
    public KeyType keyType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keyType() : this.keyType;
    }

    public final ImmutablePublicKey withValue(UnsignedByteArray value) {
        if (this.value == value) {
            return this;
        }
        UnsignedByteArray newValue = Objects.requireNonNull(value, "value");
        return new ImmutablePublicKey(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePublicKey && this.equalTo(0, (ImmutablePublicKey)another);
    }

    private boolean equalTo(int synthetic, ImmutablePublicKey another) {
        return this.value.equals(another.value) && this.base58Value.equals(another.base58Value) && this.base16Value.equals(another.base16Value) && this.keyType.equals((Object)another.keyType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.base58Value.hashCode();
        h += (h << 5) + this.base16Value.hashCode();
        h += (h << 5) + this.keyType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PublicKey").omitNullValues().add("value", (Object)this.value).add("base58Value", (Object)this.base58Value).add("base16Value", (Object)this.base16Value).add("keyType", (Object)this.keyType).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePublicKey fromJson(Json json) {
        Builder builder = ImmutablePublicKey.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address deriveAddress() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutablePublicKey immutablePublicKey = this;
            synchronized (immutablePublicKey) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.deriveAddress = Objects.requireNonNull(PublicKey.super.deriveAddress(), "deriveAddress");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.deriveAddress;
    }

    public static ImmutablePublicKey copyOf(PublicKey instance) {
        if (instance instanceof ImmutablePublicKey) {
            return (ImmutablePublicKey)instance;
        }
        return ImmutablePublicKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PublicKey", generator="Immutables")
    private final class InitShim {
        private byte base58ValueBuildStage = 0;
        private String base58Value;
        private byte base16ValueBuildStage = 0;
        private String base16Value;
        private byte keyTypeBuildStage = 0;
        private KeyType keyType;

        private InitShim() {
        }

        String base58Value() {
            if (this.base58ValueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.base58ValueBuildStage == 0) {
                this.base58ValueBuildStage = (byte)-1;
                this.base58Value = Objects.requireNonNull(ImmutablePublicKey.this.base58ValueInitialize(), "base58Value");
                this.base58ValueBuildStage = 1;
            }
            return this.base58Value;
        }

        String base16Value() {
            if (this.base16ValueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.base16ValueBuildStage == 0) {
                this.base16ValueBuildStage = (byte)-1;
                this.base16Value = Objects.requireNonNull(ImmutablePublicKey.this.base16ValueInitialize(), "base16Value");
                this.base16ValueBuildStage = 1;
            }
            return this.base16Value;
        }

        KeyType keyType() {
            if (this.keyTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyTypeBuildStage == 0) {
                this.keyTypeBuildStage = (byte)-1;
                this.keyType = Objects.requireNonNull(ImmutablePublicKey.this.keyTypeInitialize(), "keyType");
                this.keyTypeBuildStage = 1;
            }
            return this.keyType;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.base58ValueBuildStage == -1) {
                attributes.add("base58Value");
            }
            if (this.base16ValueBuildStage == -1) {
                attributes.add("base16Value");
            }
            if (this.keyTypeBuildStage == -1) {
                attributes.add("keyType");
            }
            return "Cannot build PublicKey, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="PublicKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private UnsignedByteArray value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(UnsignedByteArray value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePublicKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePublicKey(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build PublicKey, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PublicKey", generator="Immutables")
    static final class Json
    implements PublicKey {
        @Nullable
        UnsignedByteArray value;

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(UnsignedByteArray value) {
            this.value = value;
        }

        @Override
        public UnsignedByteArray value() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String base58Value() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String base16Value() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public KeyType keyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address deriveAddress() {
            throw new UnsupportedOperationException();
        }
    }
}

