/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.crypto.keys.KeyPair;
import org.xrpl.xrpl4j.crypto.keys.PrivateKey;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyPair", generator="Immutables")
@Immutable
public final class ImmutableKeyPair
implements KeyPair {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    private ImmutableKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    @Override
    public PrivateKey privateKey() {
        return this.privateKey;
    }

    @Override
    public PublicKey publicKey() {
        return this.publicKey;
    }

    public final ImmutableKeyPair withPrivateKey(PrivateKey value) {
        if (this.privateKey == value) {
            return this;
        }
        PrivateKey newValue = Objects.requireNonNull(value, "privateKey");
        return new ImmutableKeyPair(newValue, this.publicKey);
    }

    public final ImmutableKeyPair withPublicKey(PublicKey value) {
        if (this.publicKey == value) {
            return this;
        }
        PublicKey newValue = Objects.requireNonNull(value, "publicKey");
        return new ImmutableKeyPair(this.privateKey, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyPair && this.equalTo(0, (ImmutableKeyPair)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyPair another) {
        return this.privateKey.equals(another.privateKey) && this.publicKey.equals(another.publicKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.privateKey.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyPair").omitNullValues().add("privateKey", (Object)this.privateKey).add("publicKey", (Object)this.publicKey).toString();
    }

    public static ImmutableKeyPair copyOf(KeyPair instance) {
        if (instance instanceof ImmutableKeyPair) {
            return (ImmutableKeyPair)instance;
        }
        return ImmutableKeyPair.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyPair", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PRIVATE_KEY = 1L;
        private static final long INIT_BIT_PUBLIC_KEY = 2L;
        private long initBits = 3L;
        @Nullable
        private PrivateKey privateKey;
        @Nullable
        private PublicKey publicKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyPair instance) {
            Objects.requireNonNull(instance, "instance");
            this.privateKey(instance.privateKey());
            this.publicKey(instance.publicKey());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privateKey(PrivateKey privateKey) {
            this.privateKey = Objects.requireNonNull(privateKey, "privateKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableKeyPair build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyPair(this.privateKey, this.publicKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("privateKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("publicKey");
            }
            return "Cannot build KeyPair, some of required attributes are not set " + attributes;
        }
    }
}

