/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.Base58EncodedSecret;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Base58EncodedSecret", generator="Immutables")
@Immutable
public final class ImmutableBase58EncodedSecret
implements Base58EncodedSecret {
    private final String value;
    private final transient UnsignedByteArray decodedValueBytes;

    private ImmutableBase58EncodedSecret(String value) {
        this.value = value;
        this.decodedValueBytes = Objects.requireNonNull(Base58EncodedSecret.super.decodedValueBytes(), "decodedValueBytes");
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public UnsignedByteArray decodedValueBytes() {
        return this.decodedValueBytes;
    }

    public final ImmutableBase58EncodedSecret withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableBase58EncodedSecret(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBase58EncodedSecret && this.equalTo(0, (ImmutableBase58EncodedSecret)another);
    }

    private boolean equalTo(int synthetic, ImmutableBase58EncodedSecret another) {
        return this.value.equals(another.value) && this.decodedValueBytes.equals(another.decodedValueBytes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.decodedValueBytes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Base58EncodedSecret").omitNullValues().add("value", (Object)this.value).add("decodedValueBytes", (Object)this.decodedValueBytes).toString();
    }

    public static ImmutableBase58EncodedSecret copyOf(Base58EncodedSecret instance) {
        if (instance instanceof ImmutableBase58EncodedSecret) {
            return (ImmutableBase58EncodedSecret)instance;
        }
        return ImmutableBase58EncodedSecret.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Base58EncodedSecret", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Base58EncodedSecret instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBase58EncodedSecret build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBase58EncodedSecret(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Base58EncodedSecret, some of required attributes are not set " + attributes;
        }
    }
}

