/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.keys;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Destroyable;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.SecureRandomUtils;

public class Entropy
implements Destroyable {
    private final byte[] value;
    private boolean destroyed;

    public static Entropy newInstance() {
        byte[] entropyBytes = SecureRandomUtils.secureRandom().generateSeed(16);
        return new Entropy(entropyBytes);
    }

    public static Entropy of(byte[] entropy) {
        Objects.requireNonNull(entropy);
        return new Entropy(entropy);
    }

    private Entropy(byte[] entropy) {
        Objects.requireNonNull(entropy);
        Preconditions.checkArgument((entropy.length == 16 ? 1 : 0) != 0, (Object)"Entropy must be 16 bytes");
        byte[] copiedEntropy = new byte[entropy.length];
        System.arraycopy(entropy, 0, copiedEntropy, 0, entropy.length);
        this.value = copiedEntropy;
    }

    public UnsignedByteArray value() {
        byte[] copiedValue = new byte[this.value.length];
        System.arraycopy(this.value, 0, copiedValue, 0, this.value.length);
        return UnsignedByteArray.of(copiedValue);
    }

    @Override
    public final void destroy() {
        Arrays.fill(this.value, (byte)0);
        this.destroyed = true;
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Entropy)) {
            return false;
        }
        Entropy that = (Entropy)obj;
        return that.value().equals(this.value());
    }

    public int hashCode() {
        return this.value().hashCode();
    }

    public String toString() {
        return "Entropy{value=[redacted], destroyed=" + this.destroyed + '}';
    }
}

