/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto;

import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Destroyable;

public class ServerSecret
implements Destroyable {
    private final byte[] value;
    private boolean destroyed;

    public static ServerSecret of(byte[] value) {
        return new ServerSecret(value);
    }

    private ServerSecret(byte[] value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    public byte[] value() {
        byte[] copiedValue = new byte[this.value.length];
        System.arraycopy(this.value, 0, copiedValue, 0, this.value.length);
        return copiedValue;
    }

    @Override
    public final void destroy() {
        Arrays.fill(this.value, (byte)0);
        this.destroyed = true;
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServerSecret)) {
            return false;
        }
        ServerSecret that = (ServerSecret)obj;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return "ServerSecret{value=[redacted], destroyed=" + this.destroyed + '}';
    }
}

