/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;

public final class JavaKeystoreLoader {
    private JavaKeystoreLoader() {
    }

    public static KeyStore loadFromClasspath(String keystoreFileName, char[] keystorePassword) {
        KeyStore keyStore;
        block9: {
            Objects.requireNonNull(keystoreFileName);
            Objects.requireNonNull(keystorePassword);
            InputStream keyStoreStream = JavaKeystoreLoader.class.getResourceAsStream("/" + keystoreFileName);
            try {
                if (keyStoreStream == null) {
                    throw new FileNotFoundException("'/" + keystoreFileName + "' not found on classpath");
                }
                KeyStore keyStore2 = KeyStore.getInstance("PKCS12");
                keyStore2.load(keyStoreStream, keystorePassword);
                keyStore = keyStore2;
                if (keyStoreStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (keyStoreStream != null) {
                        try {
                            keyStoreStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new RuntimeException(e);
                }
            }
            keyStoreStream.close();
        }
        return keyStore;
    }
}

