/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto;

import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.Objects;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;

public class HashingUtils {
    public static UnsignedByteArray sha512Half(UnsignedByteArray bytes) {
        Objects.requireNonNull(bytes);
        return HashingUtils.sha512Half(bytes.toByteArray());
    }

    public static UnsignedByteArray sha512Half(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return UnsignedByteArray.of(Arrays.copyOfRange(Hashing.sha512().hashBytes(bytes).asBytes(), 0, 32));
    }

    public static UnsignedByteArray addUInt32(UnsignedByteArray bytes, Integer integerToAdd) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(integerToAdd);
        bytes.append(UnsignedByte.of((byte)(integerToAdd >>> 24) & 0xFF));
        bytes.append(UnsignedByte.of((byte)(integerToAdd >>> 16) & 0xFF));
        bytes.append(UnsignedByte.of((byte)(integerToAdd >>> 8) & 0xFF));
        bytes.append(UnsignedByte.of((byte)(integerToAdd & 0xFF)));
        return bytes;
    }
}

