/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.AccountIdType;
import org.xrpl.xrpl4j.codec.binary.types.ImmutableXChainBridge;
import org.xrpl.xrpl4j.codec.binary.types.IssueType;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;
import org.xrpl.xrpl4j.codec.binary.types.XChainBridge;

public class XChainBridgeType
extends SerializedType<XChainBridgeType> {
    private static final ObjectMapper objectMapper = BinaryCodecObjectMapperFactory.getObjectMapper();
    private static final byte[] ZERO_XCHAIN_BRIDGE = new byte[82];

    public XChainBridgeType() {
        this(UnsignedByteArray.of(ZERO_XCHAIN_BRIDGE));
    }

    public XChainBridgeType(UnsignedByteArray bytes) {
        super(bytes);
    }

    @Override
    public XChainBridgeType fromJson(JsonNode node) throws JsonProcessingException {
        if (!node.isObject()) {
            throw new IllegalArgumentException("node is not an object");
        }
        XChainBridge bridge = (XChainBridge)objectMapper.treeToValue((TreeNode)node, XChainBridge.class);
        UnsignedByteArray byteArray = UnsignedByteArray.of(UnsignedByte.of(20), new UnsignedByte[0]);
        byteArray.append(new AccountIdType().fromJson(bridge.lockingChainDoor()).value());
        byteArray.append(new IssueType().fromJson(bridge.lockingChainIssue()).value());
        byteArray.append(UnsignedByte.of(20));
        byteArray.append(new AccountIdType().fromJson(bridge.issuingChainDoor()).value());
        byteArray.append(new IssueType().fromJson(bridge.issuingChainIssue()).value());
        return new XChainBridgeType(byteArray);
    }

    @Override
    public XChainBridgeType fromParser(BinaryParser parser) {
        parser.skip(1);
        AccountIdType lockingChainDoor = new AccountIdType().fromParser(parser);
        IssueType lockingChainIssue = new IssueType().fromParser(parser);
        parser.skip(1);
        AccountIdType issuingChainDoor = new AccountIdType().fromParser(parser);
        IssueType issuingChainIssue = new IssueType().fromParser(parser);
        return new XChainBridgeType(UnsignedByteArray.of(UnsignedByte.of(20), new UnsignedByte[0]).append(lockingChainDoor.value()).append(lockingChainIssue.value()).append(UnsignedByte.of(20)).append(issuingChainDoor.value()).append(issuingChainIssue.value()));
    }

    @Override
    public JsonNode toJson() {
        BinaryParser parser = new BinaryParser(this.toHex());
        parser.skip(1);
        AccountIdType lockingChainDoor = new AccountIdType().fromParser(parser);
        IssueType lockingChainIssue = new IssueType().fromParser(parser);
        parser.skip(1);
        AccountIdType issuingChainDoor = new AccountIdType().fromParser(parser);
        IssueType issuingChainIssue = new IssueType().fromParser(parser);
        ImmutableXChainBridge bridge = XChainBridge.builder().lockingChainDoor(lockingChainDoor.toJson()).lockingChainIssue(lockingChainIssue.toJson()).issuingChainDoor(issuingChainDoor.toJson()).issuingChainIssue(issuingChainIssue.toJson()).build();
        return objectMapper.valueToTree((Object)bridge);
    }

    static {
        XChainBridgeType.ZERO_XCHAIN_BRIDGE[0] = 20;
        XChainBridgeType.ZERO_XCHAIN_BRIDGE[41] = 20;
    }
}

