/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.primitives.UnsignedLong;
import org.xrpl.xrpl4j.codec.addresses.ByteUtils;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

abstract class UIntType<T extends UIntType<T>>
extends SerializedType<T> {
    private final UnsignedLong value;

    public UIntType(UnsignedLong value, int bitSize) {
        super(UnsignedByteArray.fromHex(ByteUtils.padded(value.toString(16), UIntType.bitSizeToHexLength(bitSize))));
        this.value = value;
    }

    private static int bitSizeToHexLength(int bitSize) {
        return bitSize / 4;
    }

    UnsignedLong valueOf() {
        return this.value;
    }

    @Override
    public JsonNode toJson() {
        return new TextNode(UnsignedLong.valueOf((String)this.toHex(), (int)16).toString());
    }
}

