/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.codec.binary.types.ImmutableIssue;

@JsonSerialize(as=ImmutableIssue.class)
@JsonDeserialize(as=ImmutableIssue.class)
@Value.Immutable
public interface Issue {
    public static ImmutableIssue.Builder builder() {
        return ImmutableIssue.builder();
    }

    public JsonNode currency();

    public Optional<JsonNode> issuer();

    @Value.Check
    default public void checkIssuerEmptyForXrp() {
        if (this.currency().asText().equals("XRP")) {
            Preconditions.checkState((!this.issuer().isPresent() ? 1 : 0) != 0, (Object)"If Issue is XRP, issuer must be empty.");
        }
    }
}

