/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.binary.types.Amount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Amount", generator="Immutables")
@Immutable
final class ImmutableAmount
implements Amount {
    private final String currency;
    private final String value;
    private final String issuer;

    private ImmutableAmount(String currency, String value, String issuer) {
        this.currency = currency;
        this.value = value;
        this.issuer = issuer;
    }

    @Override
    @JsonProperty(value="currency")
    public String currency() {
        return this.currency;
    }

    @Override
    @JsonProperty(value="value")
    public String value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="issuer")
    public String issuer() {
        return this.issuer;
    }

    public final ImmutableAmount withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableAmount(newValue, this.value, this.issuer);
    }

    public final ImmutableAmount withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableAmount(this.currency, newValue, this.issuer);
    }

    public final ImmutableAmount withIssuer(String value) {
        String newValue = Objects.requireNonNull(value, "issuer");
        if (this.issuer.equals(newValue)) {
            return this;
        }
        return new ImmutableAmount(this.currency, this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAmount && this.equalTo(0, (ImmutableAmount)another);
    }

    private boolean equalTo(int synthetic, ImmutableAmount another) {
        return this.currency.equals(another.currency) && this.value.equals(another.value) && this.issuer.equals(another.issuer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Amount").omitNullValues().add("currency", (Object)this.currency).add("value", (Object)this.value).add("issuer", (Object)this.issuer).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAmount fromJson(Json json) {
        Builder builder = ImmutableAmount.builder();
        if (json.currency != null) {
            builder.currency(json.currency);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        return builder.build();
    }

    public static ImmutableAmount copyOf(Amount instance) {
        if (instance instanceof ImmutableAmount) {
            return (ImmutableAmount)instance;
        }
        return ImmutableAmount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Amount", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CURRENCY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_ISSUER = 4L;
        private long initBits = 7L;
        @Nullable
        private String currency;
        @Nullable
        private String value;
        @Nullable
        private String issuer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Amount instance) {
            Objects.requireNonNull(instance, "instance");
            this.currency(instance.currency());
            this.value(instance.value());
            this.issuer(instance.issuer());
            return this;
        }

        @JsonProperty(value="currency")
        @CanIgnoreReturnValue
        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="issuer")
        @CanIgnoreReturnValue
        public final Builder issuer(String issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAmount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAmount(this.currency, this.value, this.issuer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("issuer");
            }
            return "Cannot build Amount, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Amount", generator="Immutables")
    static final class Json
    implements Amount {
        @Nullable
        String currency;
        @Nullable
        String value;
        @Nullable
        String issuer;

        Json() {
        }

        @JsonProperty(value="currency")
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="issuer")
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public String currency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String issuer() {
            throw new UnsupportedOperationException();
        }
    }
}

