/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.google.common.base.Preconditions;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

public abstract class HashType<T extends HashType<T>>
extends SerializedType<T> {
    private final int width;

    public HashType(UnsignedByteArray bytes, int width) {
        super(bytes);
        Preconditions.checkArgument((bytes.length() == width ? 1 : 0) != 0, (Object)("Invalid hash length " + bytes.length()));
        this.width = width;
    }

    @Override
    public String toString() {
        return this.toHex();
    }

    @Override
    public T fromHex(String hex) {
        return (T)((HashType)super.fromHex(hex, this.width));
    }

    public int getWidth() {
        return this.width;
    }

    public int nibblet(int depth) {
        int byteIndex = depth > 0 ? depth / 2 | 0 : 0;
        int theByte = this.value().get(byteIndex).asInt();
        theByte = depth % 2 == 0 ? (theByte & 0xF0) >>> 4 : (theByte &= 0xF);
        return theByte;
    }
}

