/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Optional;
import java.util.regex.Pattern;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.Hash160Type;

public class CurrencyType
extends Hash160Type {
    private static final Pattern ISO_REGEX = Pattern.compile("^[a-zA-Z0-9]{3}$");
    private final Optional<String> iso;

    public CurrencyType() {
        this(UnsignedByteArray.ofSize(20));
    }

    public CurrencyType(UnsignedByteArray list) {
        super(list);
        boolean lossLessISO;
        String rawISO = this.rawISO(list);
        boolean isNative = this.isNative(list);
        boolean bl = lossLessISO = this.onlyIso(list) && !rawISO.equals("XRP") && ISO_REGEX.matcher(rawISO).matches();
        this.iso = isNative ? Optional.of("XRP") : (lossLessISO ? Optional.of(rawISO) : Optional.empty());
    }

    @Override
    public CurrencyType fromParser(BinaryParser parser) {
        return new CurrencyType(parser.read(this.getWidth()));
    }

    @Override
    public CurrencyType fromJson(JsonNode node) {
        String textValue = node.textValue();
        if (!this.isValidRepresentation(textValue)) {
            throw new IllegalArgumentException("Unsupported Currency representation: " + textValue);
        }
        UnsignedByteArray bytes = textValue.length() == 3 ? this.isoToBytes(textValue) : UnsignedByteArray.fromHex(textValue);
        return new CurrencyType(bytes);
    }

    @Override
    public JsonNode toJson() {
        return (JsonNode)this.iso.map(TextNode::new).orElseGet(() -> new TextNode(this.toHex()));
    }

    private boolean isNative(UnsignedByteArray byteList) {
        String iso = byteList.slice(12, 15).hexValue();
        return this.onlyIso(byteList) && iso.equals("000000");
    }

    private boolean onlyIso(UnsignedByteArray byteList) {
        for (int i = byteList.length() - 1; i >= 0; --i) {
            if (byteList.get(i).asInt() == 0 || i == 12 || i == 13 || i == 14) continue;
            return false;
        }
        return true;
    }

    private String rawISO(UnsignedByteArray list) {
        return new String(list.slice(12, 15).toByteArray());
    }

    boolean isValidRepresentation(String value) {
        return this.isStringRepresentation(value);
    }

    private boolean isIsoCode(String iso) {
        return ISO_REGEX.matcher(iso).matches();
    }

    private boolean isHex(String hex) {
        return HEX_REGEX.matcher(hex).matches();
    }

    boolean isStringRepresentation(String input) {
        return this.isIsoCode(input) || this.isHex(input);
    }

    private UnsignedByteArray isoToBytes(String iso) {
        UnsignedByteArray bytes = UnsignedByteArray.ofSize(20);
        if (!iso.equals("XRP")) {
            for (int i = 0; i < iso.length(); ++i) {
                bytes.set(12 + i, UnsignedByte.of(iso.charAt(i)));
            }
        }
        return bytes;
    }
}

