/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.serdes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.FieldHeaderCodec;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

public class BinarySerializer {
    private final UnsignedByteArray sink;

    public BinarySerializer(UnsignedByteArray sink) {
        this.sink = sink;
    }

    public void put(String hexBytes) {
        this.sink.append(UnsignedByteArray.fromHex(hexBytes));
    }

    public void write(UnsignedByteArray list) {
        this.sink.append(list);
    }

    private UnsignedByteArray encodeVariableLength(int length) {
        if (length <= 192) {
            return UnsignedByteArray.of(UnsignedByte.of(length), new UnsignedByte[0]);
        }
        if (length <= 12480) {
            int byte1 = 193 + ((length -= 193) >>> 8);
            int byte2 = length & 0xFF;
            return UnsignedByteArray.of(UnsignedByte.of(byte1), UnsignedByte.of(byte2));
        }
        if (length <= 918744) {
            int byte1 = 241 + ((length -= 12481) >>> 16);
            int byte2 = length >> 8 & 0xFF;
            int byte3 = length & 0xFF;
            return UnsignedByteArray.of(UnsignedByte.of(byte1), UnsignedByte.of(byte2), UnsignedByte.of(byte3));
        }
        throw new Error("Overflow error");
    }

    public void writeFieldAndValue(FieldInstance field, SerializedType value) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(value);
        String fieldHeaderHex = FieldHeaderCodec.getInstance().encode(field.name());
        this.sink.append(UnsignedByteArray.fromHex(fieldHeaderHex));
        if (field.isVariableLengthEncoded()) {
            this.writeLengthEncoded(value);
        } else {
            value.toBytesSink(this.sink);
        }
    }

    public void writeFieldAndValue(FieldInstance field, JsonNode value) throws JsonProcessingException {
        Objects.requireNonNull(field);
        Objects.requireNonNull(value);
        Object typedValue = field.name().equals("BaseFee") ? SerializedType.getTypeByName(field.type()).fromHex(value.asText()) : SerializedType.getTypeByName(field.type()).fromJson(value);
        this.writeFieldAndValue(field, (SerializedType)typedValue);
    }

    public void writeLengthEncoded(SerializedType value) {
        Objects.requireNonNull(value);
        UnsignedByteArray bytes = UnsignedByteArray.empty();
        value.toBytesSink(bytes);
        this.put(this.encodeVariableLength(bytes.length()).hexValue());
        this.write(bytes);
    }
}

