/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.definitions;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.binary.FieldHeader;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FieldInstance", generator="Immutables")
@Immutable
public final class ImmutableFieldInstance
implements FieldInstance {
    private final int nth;
    private final boolean isSigningField;
    private final boolean isSerialized;
    private final String name;
    private final String type;
    private final boolean isVariableLengthEncoded;
    private final FieldHeader header;

    private ImmutableFieldInstance(int nth, boolean isSigningField, boolean isSerialized, String name, String type, boolean isVariableLengthEncoded, FieldHeader header) {
        this.nth = nth;
        this.isSigningField = isSigningField;
        this.isSerialized = isSerialized;
        this.name = name;
        this.type = type;
        this.isVariableLengthEncoded = isVariableLengthEncoded;
        this.header = header;
    }

    @Override
    public int nth() {
        return this.nth;
    }

    @Override
    public boolean isSigningField() {
        return this.isSigningField;
    }

    @Override
    public boolean isSerialized() {
        return this.isSerialized;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public boolean isVariableLengthEncoded() {
        return this.isVariableLengthEncoded;
    }

    @Override
    public FieldHeader header() {
        return this.header;
    }

    public final ImmutableFieldInstance withNth(int value) {
        if (this.nth == value) {
            return this;
        }
        return new ImmutableFieldInstance(value, this.isSigningField, this.isSerialized, this.name, this.type, this.isVariableLengthEncoded, this.header);
    }

    public final ImmutableFieldInstance withIsSigningField(boolean value) {
        if (this.isSigningField == value) {
            return this;
        }
        return new ImmutableFieldInstance(this.nth, value, this.isSerialized, this.name, this.type, this.isVariableLengthEncoded, this.header);
    }

    public final ImmutableFieldInstance withIsSerialized(boolean value) {
        if (this.isSerialized == value) {
            return this;
        }
        return new ImmutableFieldInstance(this.nth, this.isSigningField, value, this.name, this.type, this.isVariableLengthEncoded, this.header);
    }

    public final ImmutableFieldInstance withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableFieldInstance(this.nth, this.isSigningField, this.isSerialized, newValue, this.type, this.isVariableLengthEncoded, this.header);
    }

    public final ImmutableFieldInstance withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableFieldInstance(this.nth, this.isSigningField, this.isSerialized, this.name, newValue, this.isVariableLengthEncoded, this.header);
    }

    public final ImmutableFieldInstance withIsVariableLengthEncoded(boolean value) {
        if (this.isVariableLengthEncoded == value) {
            return this;
        }
        return new ImmutableFieldInstance(this.nth, this.isSigningField, this.isSerialized, this.name, this.type, value, this.header);
    }

    public final ImmutableFieldInstance withHeader(FieldHeader value) {
        if (this.header == value) {
            return this;
        }
        FieldHeader newValue = Objects.requireNonNull(value, "header");
        return new ImmutableFieldInstance(this.nth, this.isSigningField, this.isSerialized, this.name, this.type, this.isVariableLengthEncoded, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldInstance && this.equalTo(0, (ImmutableFieldInstance)another);
    }

    private boolean equalTo(int synthetic, ImmutableFieldInstance another) {
        return this.nth == another.nth && this.isSigningField == another.isSigningField && this.isSerialized == another.isSerialized && this.name.equals(another.name) && this.type.equals(another.type) && this.isVariableLengthEncoded == another.isVariableLengthEncoded && this.header.equals(another.header);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nth;
        h += (h << 5) + Booleans.hashCode((boolean)this.isSigningField);
        h += (h << 5) + Booleans.hashCode((boolean)this.isSerialized);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isVariableLengthEncoded);
        h += (h << 5) + this.header.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FieldInstance").omitNullValues().add("nth", this.nth).add("isSigningField", this.isSigningField).add("isSerialized", this.isSerialized).add("name", (Object)this.name).add("type", (Object)this.type).add("isVariableLengthEncoded", this.isVariableLengthEncoded).add("header", (Object)this.header).toString();
    }

    public static ImmutableFieldInstance copyOf(FieldInstance instance) {
        if (instance instanceof ImmutableFieldInstance) {
            return (ImmutableFieldInstance)instance;
        }
        return ImmutableFieldInstance.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FieldInstance", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NTH = 1L;
        private static final long INIT_BIT_IS_SIGNING_FIELD = 2L;
        private static final long INIT_BIT_IS_SERIALIZED = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private static final long INIT_BIT_IS_VARIABLE_LENGTH_ENCODED = 32L;
        private static final long INIT_BIT_HEADER = 64L;
        private long initBits = 127L;
        private int nth;
        private boolean isSigningField;
        private boolean isSerialized;
        @Nullable
        private String name;
        @Nullable
        private String type;
        private boolean isVariableLengthEncoded;
        @Nullable
        private FieldHeader header;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FieldInstance instance) {
            Objects.requireNonNull(instance, "instance");
            this.nth(instance.nth());
            this.isSigningField(instance.isSigningField());
            this.isSerialized(instance.isSerialized());
            this.name(instance.name());
            this.type(instance.type());
            this.isVariableLengthEncoded(instance.isVariableLengthEncoded());
            this.header(instance.header());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nth(int nth) {
            this.nth = nth;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSigningField(boolean isSigningField) {
            this.isSigningField = isSigningField;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSerialized(boolean isSerialized) {
            this.isSerialized = isSerialized;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isVariableLengthEncoded(boolean isVariableLengthEncoded) {
            this.isVariableLengthEncoded = isVariableLengthEncoded;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder header(FieldHeader header) {
            this.header = Objects.requireNonNull(header, "header");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableFieldInstance build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldInstance(this.nth, this.isSigningField, this.isSerialized, this.name, this.type, this.isVariableLengthEncoded, this.header);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nth");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isSigningField");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isSerialized");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("isVariableLengthEncoded");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("header");
            }
            return "Cannot build FieldInstance, some of required attributes are not set " + attributes;
        }
    }
}

