/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.definitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInfo;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FieldInfo", generator="Immutables")
@Immutable
public final class ImmutableFieldInfo
implements FieldInfo {
    private final int nth;
    private final boolean isSigningField;
    private final boolean isSerialized;
    private final String type;
    private final boolean isVariableLengthEncoded;

    private ImmutableFieldInfo(int nth, boolean isSigningField, boolean isSerialized, String type, boolean isVariableLengthEncoded) {
        this.nth = nth;
        this.isSigningField = isSigningField;
        this.isSerialized = isSerialized;
        this.type = type;
        this.isVariableLengthEncoded = isVariableLengthEncoded;
    }

    @Override
    @JsonProperty(value="nth")
    public int nth() {
        return this.nth;
    }

    @Override
    @JsonProperty(value="isSigningField")
    public boolean isSigningField() {
        return this.isSigningField;
    }

    @Override
    @JsonProperty(value="isSerialized")
    public boolean isSerialized() {
        return this.isSerialized;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="isVLEncoded")
    public boolean isVariableLengthEncoded() {
        return this.isVariableLengthEncoded;
    }

    public final ImmutableFieldInfo withNth(int value) {
        if (this.nth == value) {
            return this;
        }
        return new ImmutableFieldInfo(value, this.isSigningField, this.isSerialized, this.type, this.isVariableLengthEncoded);
    }

    public final ImmutableFieldInfo withIsSigningField(boolean value) {
        if (this.isSigningField == value) {
            return this;
        }
        return new ImmutableFieldInfo(this.nth, value, this.isSerialized, this.type, this.isVariableLengthEncoded);
    }

    public final ImmutableFieldInfo withIsSerialized(boolean value) {
        if (this.isSerialized == value) {
            return this;
        }
        return new ImmutableFieldInfo(this.nth, this.isSigningField, value, this.type, this.isVariableLengthEncoded);
    }

    public final ImmutableFieldInfo withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableFieldInfo(this.nth, this.isSigningField, this.isSerialized, newValue, this.isVariableLengthEncoded);
    }

    public final ImmutableFieldInfo withIsVariableLengthEncoded(boolean value) {
        if (this.isVariableLengthEncoded == value) {
            return this;
        }
        return new ImmutableFieldInfo(this.nth, this.isSigningField, this.isSerialized, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldInfo && this.equalTo(0, (ImmutableFieldInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableFieldInfo another) {
        return this.nth == another.nth && this.isSigningField == another.isSigningField && this.isSerialized == another.isSerialized && this.type.equals(another.type) && this.isVariableLengthEncoded == another.isVariableLengthEncoded;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nth;
        h += (h << 5) + Booleans.hashCode((boolean)this.isSigningField);
        h += (h << 5) + Booleans.hashCode((boolean)this.isSerialized);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isVariableLengthEncoded);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FieldInfo").omitNullValues().add("nth", this.nth).add("isSigningField", this.isSigningField).add("isSerialized", this.isSerialized).add("type", (Object)this.type).add("isVariableLengthEncoded", this.isVariableLengthEncoded).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFieldInfo fromJson(Json json) {
        Builder builder = ImmutableFieldInfo.builder();
        if (json.nthIsSet) {
            builder.nth(json.nth);
        }
        if (json.isSigningFieldIsSet) {
            builder.isSigningField(json.isSigningField);
        }
        if (json.isSerializedIsSet) {
            builder.isSerialized(json.isSerialized);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.isVariableLengthEncodedIsSet) {
            builder.isVariableLengthEncoded(json.isVariableLengthEncoded);
        }
        return builder.build();
    }

    public static ImmutableFieldInfo copyOf(FieldInfo instance) {
        if (instance instanceof ImmutableFieldInfo) {
            return (ImmutableFieldInfo)instance;
        }
        return ImmutableFieldInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FieldInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NTH = 1L;
        private static final long INIT_BIT_IS_SIGNING_FIELD = 2L;
        private static final long INIT_BIT_IS_SERIALIZED = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_IS_VARIABLE_LENGTH_ENCODED = 16L;
        private long initBits = 31L;
        private int nth;
        private boolean isSigningField;
        private boolean isSerialized;
        @Nullable
        private String type;
        private boolean isVariableLengthEncoded;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FieldInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.nth(instance.nth());
            this.isSigningField(instance.isSigningField());
            this.isSerialized(instance.isSerialized());
            this.type(instance.type());
            this.isVariableLengthEncoded(instance.isVariableLengthEncoded());
            return this;
        }

        @JsonProperty(value="nth")
        @CanIgnoreReturnValue
        public final Builder nth(int nth) {
            this.nth = nth;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="isSigningField")
        @CanIgnoreReturnValue
        public final Builder isSigningField(boolean isSigningField) {
            this.isSigningField = isSigningField;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="isSerialized")
        @CanIgnoreReturnValue
        public final Builder isSerialized(boolean isSerialized) {
            this.isSerialized = isSerialized;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="isVLEncoded")
        @CanIgnoreReturnValue
        public final Builder isVariableLengthEncoded(boolean isVariableLengthEncoded) {
            this.isVariableLengthEncoded = isVariableLengthEncoded;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableFieldInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldInfo(this.nth, this.isSigningField, this.isSerialized, this.type, this.isVariableLengthEncoded);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nth");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isSigningField");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isSerialized");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("isVariableLengthEncoded");
            }
            return "Cannot build FieldInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FieldInfo", generator="Immutables")
    static final class Json
    implements FieldInfo {
        int nth;
        boolean nthIsSet;
        boolean isSigningField;
        boolean isSigningFieldIsSet;
        boolean isSerialized;
        boolean isSerializedIsSet;
        @Nullable
        String type;
        boolean isVariableLengthEncoded;
        boolean isVariableLengthEncodedIsSet;

        Json() {
        }

        @JsonProperty(value="nth")
        public void setNth(int nth) {
            this.nth = nth;
            this.nthIsSet = true;
        }

        @JsonProperty(value="isSigningField")
        public void setIsSigningField(boolean isSigningField) {
            this.isSigningField = isSigningField;
            this.isSigningFieldIsSet = true;
        }

        @JsonProperty(value="isSerialized")
        public void setIsSerialized(boolean isSerialized) {
            this.isSerialized = isSerialized;
            this.isSerializedIsSet = true;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="isVLEncoded")
        public void setIsVariableLengthEncoded(boolean isVariableLengthEncoded) {
            this.isVariableLengthEncoded = isVariableLengthEncoded;
            this.isVariableLengthEncodedIsSet = true;
        }

        @Override
        public int nth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSigningField() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSerialized() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isVariableLengthEncoded() {
            throw new UnsupportedOperationException();
        }
    }
}

