/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.definitions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.Resources;
import java.io.IOException;
import java.util.Objects;
import org.xrpl.xrpl4j.codec.binary.definitions.Definitions;
import org.xrpl.xrpl4j.codec.binary.definitions.DefinitionsProvider;

public class DefaultDefinitionsProvider
implements DefinitionsProvider {
    private final Supplier<Definitions> supplier;

    public DefaultDefinitionsProvider(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        this.supplier = Suppliers.memoize(() -> {
            try {
                return (Definitions)objectMapper.readerFor(Definitions.class).readValue(Resources.getResource(DefaultDefinitionsProvider.class, (String)"/definitions.json"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read definition.json file", e);
            }
        });
    }

    @Override
    public Definitions get() {
        return (Definitions)this.supplier.get();
    }
}

