/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.math.BigInteger;
import java.util.Objects;
import javax.security.auth.Destroyable;

public class UnsignedByte
implements Destroyable {
    private int value;
    private boolean destroyed;

    private UnsignedByte(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((value <= 255 ? 1 : 0) != 0);
        this.value = value;
    }

    public static UnsignedByte of(UnsignedByte value) {
        return new UnsignedByte(value.asInt());
    }

    public static UnsignedByte of(int value) {
        return new UnsignedByte(value);
    }

    public static UnsignedByte of(byte value) {
        return new UnsignedByte(value & 0xFF);
    }

    public static UnsignedByte of(byte highBits, byte lowBits) {
        return new UnsignedByte((highBits << 4) + lowBits);
    }

    public static UnsignedByte of(String hex) {
        Objects.requireNonNull(hex);
        byte highBits = new BigInteger(hex.substring(0, 1), 16).byteValue();
        byte lowBits = new BigInteger(hex.substring(1, 2), 16).byteValue();
        return UnsignedByte.of(highBits, lowBits);
    }

    public int asInt() {
        return this.value;
    }

    public byte asByte() {
        return (byte)this.value;
    }

    public int getHighBits() {
        return this.value >> 4;
    }

    public int getLowBits() {
        return this.value & 0xF;
    }

    public boolean isNthBitSet(int nth) {
        Preconditions.checkArgument((nth >= 1 && nth <= 8 ? 1 : 0) != 0);
        return (this.value >> 8 - nth & 1) == 1;
    }

    public UnsignedByte or(UnsignedByte unsignedByte) {
        return UnsignedByte.of(this.value | unsignedByte.value);
    }

    public String hexValue() {
        return BaseEncoding.base16().encode(new byte[]{(byte)this.asInt()});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnsignedByte)) {
            return false;
        }
        UnsignedByte that = (UnsignedByte)object;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public void destroy() {
        this.value = 0;
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

