/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedInteger;
import java.util.Objects;
import java.util.Optional;
import org.xrpl.xrpl4j.codec.addresses.AddressBase58;
import org.xrpl.xrpl4j.codec.addresses.Decoded;
import org.xrpl.xrpl4j.codec.addresses.KeyType;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.addresses.Version;
import org.xrpl.xrpl4j.codec.addresses.exceptions.EncodeException;
import org.xrpl.xrpl4j.codec.addresses.exceptions.EncodingFormatException;

public class SeedCodec {
    private static final SeedCodec INSTANCE = new SeedCodec();

    public static SeedCodec getInstance() {
        return INSTANCE;
    }

    public Decoded decodeSeed(String base58EncodedSeed) throws EncodingFormatException {
        Objects.requireNonNull(base58EncodedSeed);
        return AddressBase58.decode(base58EncodedSeed, Lists.newArrayList((Object[])new KeyType[]{KeyType.ED25519, KeyType.SECP256K1}), Lists.newArrayList((Object[])new Version[]{Version.ED25519_SEED, Version.FAMILY_SEED}), Optional.of(UnsignedInteger.valueOf((long)16L)));
    }

    public String encodeSeed(UnsignedByteArray entropy, KeyType type) {
        Objects.requireNonNull(entropy);
        Objects.requireNonNull(type);
        if (entropy.getUnsignedBytes().size() != 16) {
            throw new EncodeException("entropy must have length 16.");
        }
        Version version = type.equals((Object)KeyType.ED25519) ? Version.ED25519_SEED : Version.FAMILY_SEED;
        return AddressBase58.encode(entropy, Lists.newArrayList((Object[])new Version[]{version}), UnsignedInteger.valueOf((long)16L));
    }
}

