/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedInteger;
import java.util.Objects;
import org.xrpl.xrpl4j.codec.addresses.AddressBase58;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.addresses.Version;

public class PublicKeyCodec {
    private static final PublicKeyCodec INSTANCE = new PublicKeyCodec();

    public static PublicKeyCodec getInstance() {
        return INSTANCE;
    }

    public String encodeNodePublicKey(UnsignedByteArray publicKey) {
        Objects.requireNonNull(publicKey);
        return AddressBase58.encode(publicKey, Lists.newArrayList((Object[])new Version[]{Version.NODE_PUBLIC}), UnsignedInteger.valueOf((long)33L));
    }

    public UnsignedByteArray decodeNodePublicKey(String publicKey) {
        Objects.requireNonNull(publicKey);
        return AddressBase58.decode(publicKey, Lists.newArrayList((Object[])new Version[]{Version.NODE_PUBLIC}), UnsignedInteger.valueOf((long)33L)).bytes();
    }

    public String encodeAccountPublicKey(UnsignedByteArray publicKey) {
        Objects.requireNonNull(publicKey);
        return AddressBase58.encode(publicKey, Lists.newArrayList((Object[])new Version[]{Version.ACCOUNT_PUBLIC_KEY}), UnsignedInteger.valueOf((long)33L));
    }

    public UnsignedByteArray decodeAccountPublicKey(String publicKey) {
        Objects.requireNonNull(publicKey);
        return AddressBase58.decode(publicKey, Lists.newArrayList((Object[])new Version[]{Version.ACCOUNT_PUBLIC_KEY}), UnsignedInteger.valueOf((long)33L)).bytes();
    }
}

