/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedInteger;
import java.util.Objects;
import org.xrpl.xrpl4j.codec.addresses.AddressBase58;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.addresses.Version;

public class PrivateKeyCodec {
    private static final PrivateKeyCodec INSTANCE = new PrivateKeyCodec();

    public static PrivateKeyCodec getInstance() {
        return INSTANCE;
    }

    public String encodeNodePrivateKey(UnsignedByteArray privateKeyBytes) {
        Objects.requireNonNull(privateKeyBytes);
        return AddressBase58.encode(privateKeyBytes, Lists.newArrayList((Object[])new Version[]{Version.NODE_PRIVATE}), UnsignedInteger.valueOf((long)32L));
    }

    public UnsignedByteArray decodeNodePrivateKey(String privateKeyBase58) {
        Objects.requireNonNull(privateKeyBase58);
        return AddressBase58.decode(privateKeyBase58, Lists.newArrayList((Object[])new Version[]{Version.NODE_PRIVATE}), UnsignedInteger.valueOf((long)32L)).bytes();
    }

    public String encodeAccountPrivateKey(UnsignedByteArray privateKeyBytes) {
        Objects.requireNonNull(privateKeyBytes);
        return AddressBase58.encode(privateKeyBytes, Lists.newArrayList((Object[])new Version[]{Version.ACCOUNT_SECRET_KEY}), UnsignedInteger.valueOf((long)32L));
    }

    public UnsignedByteArray decodeAccountPrivateKey(String privateKeyBase58) {
        Objects.requireNonNull(privateKeyBase58);
        return AddressBase58.decode(privateKeyBase58, Lists.newArrayList((Object[])new Version[]{Version.ACCOUNT_SECRET_KEY}), UnsignedInteger.valueOf((long)32L)).bytes();
    }
}

