/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.DecodedXAddress;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DecodedXAddress", generator="Immutables")
@Immutable
public final class ImmutableDecodedXAddress
implements DecodedXAddress {
    private final UnsignedByteArray accountId;
    private final UnsignedInteger tag;
    private final boolean test;

    private ImmutableDecodedXAddress(UnsignedByteArray accountId, UnsignedInteger tag, boolean test) {
        this.accountId = accountId;
        this.tag = tag;
        this.test = test;
    }

    @Override
    public UnsignedByteArray accountId() {
        return this.accountId;
    }

    @Override
    public UnsignedInteger tag() {
        return this.tag;
    }

    @Override
    public boolean test() {
        return this.test;
    }

    public final ImmutableDecodedXAddress withAccountId(UnsignedByteArray value) {
        if (this.accountId == value) {
            return this;
        }
        UnsignedByteArray newValue = Objects.requireNonNull(value, "accountId");
        return new ImmutableDecodedXAddress(newValue, this.tag, this.test);
    }

    public final ImmutableDecodedXAddress withTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "tag");
        if (this.tag.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDecodedXAddress(this.accountId, newValue, this.test);
    }

    public final ImmutableDecodedXAddress withTest(boolean value) {
        if (this.test == value) {
            return this;
        }
        return new ImmutableDecodedXAddress(this.accountId, this.tag, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDecodedXAddress && this.equalTo(0, (ImmutableDecodedXAddress)another);
    }

    private boolean equalTo(int synthetic, ImmutableDecodedXAddress another) {
        return this.accountId.equals(another.accountId) && this.tag.equals((Object)another.tag) && this.test == another.test;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accountId.hashCode();
        h += (h << 5) + this.tag.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.test);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DecodedXAddress").omitNullValues().add("accountId", (Object)this.accountId).add("tag", (Object)this.tag).add("test", this.test).toString();
    }

    public static ImmutableDecodedXAddress copyOf(DecodedXAddress instance) {
        if (instance instanceof ImmutableDecodedXAddress) {
            return (ImmutableDecodedXAddress)instance;
        }
        return ImmutableDecodedXAddress.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DecodedXAddress", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT_ID = 1L;
        private static final long INIT_BIT_TAG = 2L;
        private static final long INIT_BIT_TEST = 4L;
        private long initBits = 7L;
        @Nullable
        private UnsignedByteArray accountId;
        @Nullable
        private UnsignedInteger tag;
        private boolean test;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DecodedXAddress instance) {
            Objects.requireNonNull(instance, "instance");
            this.accountId(instance.accountId());
            this.tag(instance.tag());
            this.test(instance.test());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountId(UnsignedByteArray accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tag(UnsignedInteger tag) {
            this.tag = Objects.requireNonNull(tag, "tag");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder test(boolean test) {
            this.test = test;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDecodedXAddress build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDecodedXAddress(this.accountId, this.tag, this.test);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accountId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tag");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("test");
            }
            return "Cannot build DecodedXAddress, some of required attributes are not set " + attributes;
        }
    }
}

