/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.xrpl.xrpl4j.codec.addresses.Base58;
import org.xrpl.xrpl4j.codec.addresses.Decoded;
import org.xrpl.xrpl4j.codec.addresses.KeyType;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.addresses.Version;
import org.xrpl.xrpl4j.codec.addresses.exceptions.DecodeException;
import org.xrpl.xrpl4j.codec.addresses.exceptions.EncodeException;
import org.xrpl.xrpl4j.codec.addresses.exceptions.EncodingFormatException;

public class AddressBase58
extends Base58 {
    public static String encode(UnsignedByteArray bytes, List<Version> versions, UnsignedInteger expectedLength) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(versions);
        Objects.requireNonNull(expectedLength);
        if (expectedLength.intValue() != bytes.getUnsignedBytes().size()) {
            throw new EncodeException(String.format("Length of bytes does not match expectedLength of %s.", expectedLength));
        }
        return AddressBase58.encodeChecked(bytes.toByteArray(), versions);
    }

    public static String encodeChecked(byte[] bytes, List<Version> versions) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(versions);
        int versionsLength = 0;
        for (Version version : versions) {
            versionsLength += version.getValues().length;
        }
        byte[] versionsBytes = new byte[versionsLength];
        for (int i = 0; i < versions.size(); ++i) {
            for (int j = 0; j < versions.get(i).getValues().length; ++j) {
                versionsBytes[i + j] = (byte)versions.get(i).getValues()[j];
            }
        }
        byte[] bytesAndVersions = new byte[bytes.length + versionsLength];
        System.arraycopy(versionsBytes, 0, bytesAndVersions, 0, versionsLength);
        System.arraycopy(bytes, 0, bytesAndVersions, versionsLength, bytes.length);
        return AddressBase58.encodeChecked(bytesAndVersions);
    }

    public static Decoded decode(String base58Value, Version version) {
        Objects.requireNonNull(base58Value);
        Objects.requireNonNull(version);
        return AddressBase58.decode(base58Value, new ArrayList<KeyType>(), Lists.newArrayList((Object[])new Version[]{version}), Optional.empty());
    }

    public static Decoded decode(String base58Value, List<Version> versions, UnsignedInteger expectedLength) {
        Objects.requireNonNull(base58Value);
        Objects.requireNonNull(versions);
        Objects.requireNonNull(expectedLength);
        return AddressBase58.decode(base58Value, new ArrayList<KeyType>(), versions, Optional.of(expectedLength));
    }

    public static Decoded decode(String base58Value, List<KeyType> keyTypes, List<Version> versions, Optional<UnsignedInteger> expectedLength) throws EncodingFormatException {
        Objects.requireNonNull(base58Value);
        Objects.requireNonNull(keyTypes);
        Objects.requireNonNull(versions);
        Objects.requireNonNull(expectedLength);
        byte[] withoutSum = AddressBase58.decodeChecked(base58Value);
        if (versions.size() > 1 && !expectedLength.isPresent()) {
            throw new DecodeException("expectedLength is required because there are >= 2 possible versions");
        }
        int versionLengthGuess = versions.get(0).getValues().length;
        int payloadLength = expectedLength.map(UnsignedInteger::intValue).orElse(withoutSum.length - versionLengthGuess);
        byte[] versionBytes = Arrays.copyOfRange(withoutSum, 0, withoutSum.length - payloadLength);
        byte[] payload = Arrays.copyOfRange(withoutSum, withoutSum.length - payloadLength, withoutSum.length);
        for (int i = 0; i < versions.size(); ++i) {
            Version version = versions.get(i);
            if (!Arrays.equals(versionBytes, version.getValuesAsBytes())) continue;
            return Decoded.builder().version(version).bytes(UnsignedByteArray.of(payload)).type(i < keyTypes.size() ? Optional.of(keyTypes.get(i)) : Optional.empty()).build();
        }
        throw new DecodeException("Version is invalid. Version bytes do not match any of the provided versions.");
    }
}

