/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class PublicClientAuthenticationConverter
implements AuthenticationConverter {
    public Authentication convert(HttpServletRequest request) {
        if (!OAuth2EndpointUtils.matchesPkceTokenRequest(request)) {
            return null;
        }
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId) || ((List)parameters.get((Object)"client_id")).size() != 1) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_request"));
        }
        if (((List)parameters.get((Object)"code_verifier")).size() != 1) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_request"));
        }
        parameters.remove((Object)"client_id");
        return new OAuth2ClientAuthenticationToken(clientId, new HashMap<String, Object>(parameters.toSingleValueMap()));
    }
}

