/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenRevocationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.OAuth2EndpointUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuth2TokenRevocationEndpointFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_TOKEN_REVOCATION_ENDPOINT_URI = "/oauth2/revoke";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher tokenRevocationEndpointMatcher;
    private final Converter<HttpServletRequest, Authentication> tokenRevocationAuthenticationConverter = new DefaultTokenRevocationAuthenticationConverter();
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();

    public OAuth2TokenRevocationEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_TOKEN_REVOCATION_ENDPOINT_URI);
    }

    public OAuth2TokenRevocationEndpointFilter(AuthenticationManager authenticationManager, String tokenRevocationEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)tokenRevocationEndpointUri, (String)"tokenRevocationEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.tokenRevocationEndpointMatcher = new AntPathRequestMatcher(tokenRevocationEndpointUri, HttpMethod.POST.name());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.tokenRevocationEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            this.authenticationManager.authenticate((Authentication)this.tokenRevocationAuthenticationConverter.convert((Object)request));
            response.setStatus(HttpStatus.OK.value());
        }
        catch (OAuth2AuthenticationException ex) {
            SecurityContextHolder.clearContext();
            this.sendErrorResponse(response, ex.getError());
        }
    }

    private void sendErrorResponse(HttpServletResponse response, OAuth2Error error) throws IOException {
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(HttpStatus.BAD_REQUEST);
        this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Token Revocation Parameter: " + parameterName, "https://tools.ietf.org/html/rfc7009#section-2.1");
        throw new OAuth2AuthenticationException(error);
    }

    private static class DefaultTokenRevocationAuthenticationConverter
    implements Converter<HttpServletRequest, Authentication> {
        private DefaultTokenRevocationAuthenticationConverter() {
        }

        public Authentication convert(HttpServletRequest request) {
            String tokenTypeHint;
            Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
            MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
            String token = (String)parameters.getFirst((Object)"token");
            if (!StringUtils.hasText((String)token) || ((List)parameters.get((Object)"token")).size() != 1) {
                OAuth2TokenRevocationEndpointFilter.throwError("invalid_request", "token");
            }
            if (StringUtils.hasText((String)(tokenTypeHint = (String)parameters.getFirst((Object)"token_type_hint"))) && ((List)parameters.get((Object)"token_type_hint")).size() != 1) {
                OAuth2TokenRevocationEndpointFilter.throwError("invalid_request", "token_type_hint");
            }
            return new OAuth2TokenRevocationAuthenticationToken(token, clientPrincipal, tokenTypeHint);
        }
    }
}

