/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientCredentialsAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2RefreshTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.DelegatingAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuth2TokenEndpointFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_TOKEN_ENDPOINT_URI = "/oauth2/token";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher tokenEndpointMatcher;
    private final AuthenticationConverter authorizationGrantAuthenticationConverter;
    private final HttpMessageConverter<OAuth2AccessTokenResponse> accessTokenHttpResponseConverter = new OAuth2AccessTokenResponseHttpMessageConverter();
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();

    public OAuth2TokenEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_TOKEN_ENDPOINT_URI);
    }

    public OAuth2TokenEndpointFilter(AuthenticationManager authenticationManager, String tokenEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)tokenEndpointUri, (String)"tokenEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.tokenEndpointMatcher = new AntPathRequestMatcher(tokenEndpointUri, HttpMethod.POST.name());
        ArrayList<AuthenticationConverter> converters = new ArrayList<AuthenticationConverter>();
        converters.add(new AuthorizationCodeAuthenticationConverter());
        converters.add(new RefreshTokenAuthenticationConverter());
        converters.add(new ClientCredentialsAuthenticationConverter());
        this.authorizationGrantAuthenticationConverter = new DelegatingAuthenticationConverter(converters);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.tokenEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication authorizationGrantAuthentication;
            String[] grantTypes = request.getParameterValues("grant_type");
            if (grantTypes == null || grantTypes.length != 1) {
                OAuth2TokenEndpointFilter.throwError("invalid_request", "grant_type");
            }
            if ((authorizationGrantAuthentication = this.authorizationGrantAuthenticationConverter.convert(request)) == null) {
                OAuth2TokenEndpointFilter.throwError("unsupported_grant_type", "grant_type");
            }
            OAuth2AccessTokenAuthenticationToken accessTokenAuthentication = (OAuth2AccessTokenAuthenticationToken)this.authenticationManager.authenticate(authorizationGrantAuthentication);
            this.sendAccessTokenResponse(response, accessTokenAuthentication);
        }
        catch (OAuth2AuthenticationException ex) {
            SecurityContextHolder.clearContext();
            this.sendErrorResponse(response, ex.getError());
        }
    }

    private void sendAccessTokenResponse(HttpServletResponse response, OAuth2AccessTokenAuthenticationToken accessTokenAuthentication) throws IOException {
        OAuth2AccessToken accessToken = accessTokenAuthentication.getAccessToken();
        OAuth2RefreshToken refreshToken = accessTokenAuthentication.getRefreshToken();
        Map<String, Object> additionalParameters = accessTokenAuthentication.getAdditionalParameters();
        OAuth2AccessTokenResponse.Builder builder = OAuth2AccessTokenResponse.withToken((String)accessToken.getTokenValue()).tokenType(accessToken.getTokenType()).scopes(accessToken.getScopes());
        if (accessToken.getIssuedAt() != null && accessToken.getExpiresAt() != null) {
            builder.expiresIn(ChronoUnit.SECONDS.between(accessToken.getIssuedAt(), accessToken.getExpiresAt()));
        }
        if (refreshToken != null) {
            builder.refreshToken(refreshToken.getTokenValue());
        }
        if (!CollectionUtils.isEmpty(additionalParameters)) {
            builder.additionalParameters(additionalParameters);
        }
        OAuth2AccessTokenResponse accessTokenResponse = builder.build();
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.accessTokenHttpResponseConverter.write((Object)accessTokenResponse, null, (HttpOutputMessage)httpResponse);
    }

    private void sendErrorResponse(HttpServletResponse response, OAuth2Error error) throws IOException {
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(HttpStatus.BAD_REQUEST);
        this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, "https://tools.ietf.org/html/rfc6749#section-5.2");
        throw new OAuth2AuthenticationException(error);
    }

    private static class ClientCredentialsAuthenticationConverter
    implements AuthenticationConverter {
        private ClientCredentialsAuthenticationConverter() {
        }

        public Authentication convert(HttpServletRequest request) {
            String grantType = request.getParameter("grant_type");
            if (!AuthorizationGrantType.CLIENT_CREDENTIALS.getValue().equals(grantType)) {
                return null;
            }
            Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
            MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
            String scope = (String)parameters.getFirst((Object)"scope");
            if (StringUtils.hasText((String)scope) && ((List)parameters.get((Object)"scope")).size() != 1) {
                OAuth2TokenEndpointFilter.throwError("invalid_request", "scope");
            }
            HashSet<String> requestedScopes = null;
            if (StringUtils.hasText((String)scope)) {
                requestedScopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
            }
            Map<String, Object> additionalParameters = parameters.entrySet().stream().filter(e -> !((String)e.getKey()).equals("grant_type") && !((String)e.getKey()).equals("scope")).collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0)));
            return new OAuth2ClientCredentialsAuthenticationToken(clientPrincipal, requestedScopes, additionalParameters);
        }
    }

    private static class RefreshTokenAuthenticationConverter
    implements AuthenticationConverter {
        private RefreshTokenAuthenticationConverter() {
        }

        public Authentication convert(HttpServletRequest request) {
            String scope;
            String grantType = request.getParameter("grant_type");
            if (!AuthorizationGrantType.REFRESH_TOKEN.getValue().equals(grantType)) {
                return null;
            }
            Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
            MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
            String refreshToken = (String)parameters.getFirst((Object)"refresh_token");
            if (!StringUtils.hasText((String)refreshToken) || ((List)parameters.get((Object)"refresh_token")).size() != 1) {
                OAuth2TokenEndpointFilter.throwError("invalid_request", "refresh_token");
            }
            if (StringUtils.hasText((String)(scope = (String)parameters.getFirst((Object)"scope"))) && ((List)parameters.get((Object)"scope")).size() != 1) {
                OAuth2TokenEndpointFilter.throwError("invalid_request", "scope");
            }
            HashSet<String> requestedScopes = null;
            if (StringUtils.hasText((String)scope)) {
                requestedScopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
            }
            Map<String, Object> additionalParameters = parameters.entrySet().stream().filter(e -> !((String)e.getKey()).equals("grant_type") && !((String)e.getKey()).equals("refresh_token") && !((String)e.getKey()).equals("scope")).collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0)));
            return new OAuth2RefreshTokenAuthenticationToken(refreshToken, clientPrincipal, requestedScopes, additionalParameters);
        }
    }

    private static class AuthorizationCodeAuthenticationConverter
    implements AuthenticationConverter {
        private AuthorizationCodeAuthenticationConverter() {
        }

        public Authentication convert(HttpServletRequest request) {
            String redirectUri;
            String grantType = request.getParameter("grant_type");
            if (!AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(grantType)) {
                return null;
            }
            Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
            MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
            String code = (String)parameters.getFirst((Object)"code");
            if (!StringUtils.hasText((String)code) || ((List)parameters.get((Object)"code")).size() != 1) {
                OAuth2TokenEndpointFilter.throwError("invalid_request", "code");
            }
            if (StringUtils.hasText((String)(redirectUri = (String)parameters.getFirst((Object)"redirect_uri"))) && ((List)parameters.get((Object)"redirect_uri")).size() != 1) {
                OAuth2TokenEndpointFilter.throwError("invalid_request", "redirect_uri");
            }
            Map<String, Object> additionalParameters = parameters.entrySet().stream().filter(e -> !((String)e.getKey()).equals("grant_type") && !((String)e.getKey()).equals("client_id") && !((String)e.getKey()).equals("code") && !((String)e.getKey()).equals("redirect_uri")).collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0)));
            return new OAuth2AuthorizationCodeAuthenticationToken(code, clientPrincipal, redirectUri, additionalParameters);
        }
    }
}

