/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.web.OAuth2EndpointUtils;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2AuthorizationEndpointFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_AUTHORIZATION_ENDPOINT_URI = "/oauth2/authorize";
    private static final OAuth2TokenType STATE_TOKEN_TYPE = new OAuth2TokenType("state");
    private static final String PKCE_ERROR_URI = "https://tools.ietf.org/html/rfc7636#section-4.4.1";
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final RequestMatcher authorizationRequestMatcher;
    private final RequestMatcher userConsentMatcher;
    private final StringKeyGenerator codeGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);
    private final StringKeyGenerator stateGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public OAuth2AuthorizationEndpointFilter(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        this(registeredClientRepository, authorizationService, DEFAULT_AUTHORIZATION_ENDPOINT_URI);
    }

    public OAuth2AuthorizationEndpointFilter(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, String authorizationEndpointUri) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.hasText((String)authorizationEndpointUri, (String)"authorizationEndpointUri cannot be empty");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        AntPathRequestMatcher authorizationRequestGetMatcher = new AntPathRequestMatcher(authorizationEndpointUri, HttpMethod.GET.name());
        AntPathRequestMatcher authorizationRequestPostMatcher = new AntPathRequestMatcher(authorizationEndpointUri, HttpMethod.POST.name());
        RequestMatcher openidScopeMatcher = request -> {
            String scope = request.getParameter("scope");
            return StringUtils.hasText((String)scope) && scope.contains("openid");
        };
        RequestMatcher consentActionMatcher = request -> request.getParameter("consent_action") != null;
        this.authorizationRequestMatcher = new OrRequestMatcher(new RequestMatcher[]{authorizationRequestGetMatcher, new AndRequestMatcher(new RequestMatcher[]{authorizationRequestPostMatcher, openidScopeMatcher, new NegatedRequestMatcher(consentActionMatcher)})});
        this.userConsentMatcher = new AndRequestMatcher(new RequestMatcher[]{authorizationRequestPostMatcher, consentActionMatcher});
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.authorizationRequestMatcher.matches(request)) {
            this.processAuthorizationRequest(request, response, filterChain);
        } else if (this.userConsentMatcher.matches(request)) {
            this.processUserConsent(request, response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void processAuthorizationRequest(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        OAuth2AuthorizationRequestContext authorizationRequestContext = new OAuth2AuthorizationRequestContext(request.getRequestURL().toString(), OAuth2EndpointUtils.getParameters(request));
        this.validateAuthorizationRequest(authorizationRequestContext);
        if (authorizationRequestContext.hasError()) {
            if (authorizationRequestContext.isRedirectOnError()) {
                this.sendErrorResponse(request, response, authorizationRequestContext.resolveRedirectUri(), authorizationRequestContext.getError(), authorizationRequestContext.getState());
            } else {
                this.sendErrorResponse(response, authorizationRequestContext.getError());
            }
            return;
        }
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        if (!OAuth2AuthorizationEndpointFilter.isPrincipalAuthenticated(principal)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RegisteredClient registeredClient = authorizationRequestContext.getRegisteredClient();
        OAuth2AuthorizationRequest authorizationRequest = authorizationRequestContext.buildAuthorizationRequest();
        OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient(registeredClient).principalName(principal.getName()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).attribute(Principal.class.getName(), principal).attribute(OAuth2AuthorizationRequest.class.getName(), authorizationRequest);
        if (OAuth2AuthorizationEndpointFilter.requireUserConsent(registeredClient, authorizationRequest)) {
            String state = this.stateGenerator.generateKey();
            OAuth2Authorization authorization = builder.attribute("state", state).build();
            this.authorizationService.save(authorization);
            UserConsentPage.displayConsent(request, response, registeredClient, authorization);
        } else {
            Instant issuedAt = Instant.now();
            Instant expiresAt = issuedAt.plus(5L, ChronoUnit.MINUTES);
            OAuth2AuthorizationCode authorizationCode = new OAuth2AuthorizationCode(this.codeGenerator.generateKey(), issuedAt, expiresAt);
            OAuth2Authorization authorization = builder.token(authorizationCode).attribute(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME, authorizationRequest.getScopes()).build();
            this.authorizationService.save(authorization);
            this.sendAuthorizationResponse(request, response, authorizationRequestContext.resolveRedirectUri(), authorizationCode, authorizationRequest.getState());
        }
    }

    private static boolean requireUserConsent(RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.getScopes().contains("openid") && authorizationRequest.getScopes().size() == 1) {
            return false;
        }
        return registeredClient.getClientSettings().requireUserConsent();
    }

    private void processUserConsent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserConsentRequestContext userConsentRequestContext = new UserConsentRequestContext(request.getRequestURL().toString(), OAuth2EndpointUtils.getParameters(request));
        this.validateUserConsentRequest(userConsentRequestContext);
        if (userConsentRequestContext.hasError()) {
            if (userConsentRequestContext.isRedirectOnError()) {
                this.sendErrorResponse(request, response, userConsentRequestContext.resolveRedirectUri(), userConsentRequestContext.getError(), userConsentRequestContext.getState());
            } else {
                this.sendErrorResponse(response, userConsentRequestContext.getError());
            }
            return;
        }
        if (!UserConsentPage.isConsentApproved(request)) {
            this.authorizationService.remove(userConsentRequestContext.getAuthorization());
            OAuth2Error error = OAuth2AuthorizationEndpointFilter.createError("access_denied", "client_id");
            this.sendErrorResponse(request, response, userConsentRequestContext.resolveRedirectUri(), error, userConsentRequestContext.getAuthorizationRequest().getState());
            return;
        }
        Instant issuedAt = Instant.now();
        Instant expiresAt = issuedAt.plus(5L, ChronoUnit.MINUTES);
        OAuth2AuthorizationCode authorizationCode = new OAuth2AuthorizationCode(this.codeGenerator.generateKey(), issuedAt, expiresAt);
        Set<String> authorizedScopes = userConsentRequestContext.getScopes();
        if (userConsentRequestContext.getAuthorizationRequest().getScopes().contains("openid")) {
            authorizedScopes.add("openid");
        }
        OAuth2Authorization authorization = OAuth2Authorization.from(userConsentRequestContext.getAuthorization()).token(authorizationCode).attributes(attrs -> {
            attrs.remove("state");
            attrs.put(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME, authorizedScopes);
        }).build();
        this.authorizationService.save(authorization);
        this.sendAuthorizationResponse(request, response, userConsentRequestContext.resolveRedirectUri(), authorizationCode, userConsentRequestContext.getAuthorizationRequest().getState());
    }

    private void validateAuthorizationRequest(OAuth2AuthorizationRequestContext authorizationRequestContext) {
        if (!StringUtils.hasText((String)authorizationRequestContext.getClientId()) || ((List)authorizationRequestContext.getParameters().get((Object)"client_id")).size() != 1) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "client_id"));
            return;
        }
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(authorizationRequestContext.getClientId());
        if (registeredClient == null) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "client_id"));
            return;
        }
        if (!registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.AUTHORIZATION_CODE)) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("unauthorized_client", "client_id"));
            return;
        }
        authorizationRequestContext.setRegisteredClient(registeredClient);
        if (StringUtils.hasText((String)authorizationRequestContext.getRedirectUri())) {
            if (!registeredClient.getRedirectUris().contains(authorizationRequestContext.getRedirectUri()) || ((List)authorizationRequestContext.getParameters().get((Object)"redirect_uri")).size() != 1) {
                authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "redirect_uri"));
                return;
            }
        } else if (authorizationRequestContext.isAuthenticationRequest() || registeredClient.getRedirectUris().size() != 1) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "redirect_uri"));
            return;
        }
        authorizationRequestContext.setRedirectOnError(true);
        if (!StringUtils.hasText((String)authorizationRequestContext.getResponseType()) || ((List)authorizationRequestContext.getParameters().get((Object)"response_type")).size() != 1) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "response_type"));
            return;
        }
        if (!authorizationRequestContext.getResponseType().equals(OAuth2AuthorizationResponseType.CODE.getValue())) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("unsupported_response_type", "response_type"));
            return;
        }
        Set<String> requestedScopes = authorizationRequestContext.getScopes();
        Set<String> allowedScopes = registeredClient.getScopes();
        if (!requestedScopes.isEmpty() && !allowedScopes.containsAll(requestedScopes)) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_scope", "scope"));
            return;
        }
        String codeChallenge = (String)authorizationRequestContext.getParameters().getFirst((Object)"code_challenge");
        if (StringUtils.hasText((String)codeChallenge)) {
            if (((List)authorizationRequestContext.getParameters().get((Object)"code_challenge")).size() != 1) {
                authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "code_challenge", PKCE_ERROR_URI));
                return;
            }
            String codeChallengeMethod = (String)authorizationRequestContext.getParameters().getFirst((Object)"code_challenge_method");
            if (StringUtils.hasText((String)codeChallengeMethod) && (((List)authorizationRequestContext.getParameters().get((Object)"code_challenge_method")).size() != 1 || !"S256".equals(codeChallengeMethod) && !"plain".equals(codeChallengeMethod))) {
                authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "code_challenge_method", PKCE_ERROR_URI));
                return;
            }
        } else if (registeredClient.getClientSettings().requireProofKey()) {
            authorizationRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "code_challenge", PKCE_ERROR_URI));
            return;
        }
    }

    private void validateUserConsentRequest(UserConsentRequestContext userConsentRequestContext) {
        if (!StringUtils.hasText((String)userConsentRequestContext.getState()) || ((List)userConsentRequestContext.getParameters().get((Object)"state")).size() != 1) {
            userConsentRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "state"));
            return;
        }
        OAuth2Authorization authorization = this.authorizationService.findByToken(userConsentRequestContext.getState(), STATE_TOKEN_TYPE);
        if (authorization == null) {
            userConsentRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "state"));
            return;
        }
        userConsentRequestContext.setAuthorization(authorization);
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        if (!OAuth2AuthorizationEndpointFilter.isPrincipalAuthenticated(principal) || !principal.getName().equals(authorization.getPrincipalName())) {
            userConsentRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "state"));
            return;
        }
        if (!StringUtils.hasText((String)userConsentRequestContext.getClientId()) || ((List)userConsentRequestContext.getParameters().get((Object)"client_id")).size() != 1) {
            userConsentRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "client_id"));
            return;
        }
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(userConsentRequestContext.getClientId());
        if (registeredClient == null || !registeredClient.getId().equals(authorization.getRegisteredClientId())) {
            userConsentRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_request", "client_id"));
            return;
        }
        userConsentRequestContext.setRegisteredClient(registeredClient);
        userConsentRequestContext.setRedirectOnError(true);
        Set requestedScopes = userConsentRequestContext.getAuthorizationRequest().getScopes();
        Set<String> authorizedScopes = userConsentRequestContext.getScopes();
        if (!authorizedScopes.isEmpty() && !requestedScopes.containsAll(authorizedScopes)) {
            userConsentRequestContext.setError(OAuth2AuthorizationEndpointFilter.createError("invalid_scope", "scope"));
            return;
        }
    }

    private void sendAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, String redirectUri, OAuth2AuthorizationCode authorizationCode, String state) throws IOException {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)redirectUri).queryParam("code", new Object[]{authorizationCode.getTokenValue()});
        if (StringUtils.hasText((String)state)) {
            uriBuilder.queryParam("state", new Object[]{state});
        }
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.toUriString());
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, String redirectUri, OAuth2Error error, String state) throws IOException {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)redirectUri).queryParam("error", new Object[]{error.getErrorCode()});
        if (StringUtils.hasText((String)error.getDescription())) {
            uriBuilder.queryParam("error_description", new Object[]{error.getDescription()});
        }
        if (StringUtils.hasText((String)error.getUri())) {
            uriBuilder.queryParam("error_uri", new Object[]{error.getUri()});
        }
        if (StringUtils.hasText((String)state)) {
            uriBuilder.queryParam("state", new Object[]{state});
        }
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.toUriString());
    }

    private void sendErrorResponse(HttpServletResponse response, OAuth2Error error) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value(), error.toString());
    }

    private static OAuth2Error createError(String errorCode, String parameterName) {
        return OAuth2AuthorizationEndpointFilter.createError(errorCode, parameterName, "https://tools.ietf.org/html/rfc6749#section-4.1.2.1");
    }

    private static OAuth2Error createError(String errorCode, String parameterName, String errorUri) {
        return new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, errorUri);
    }

    private static boolean isPrincipalAuthenticated(Authentication principal) {
        return principal != null && !AnonymousAuthenticationToken.class.isAssignableFrom(principal.getClass()) && principal.isAuthenticated();
    }

    private static class UserConsentPage {
        private static final MediaType TEXT_HTML_UTF8 = new MediaType("text", "html", StandardCharsets.UTF_8);
        private static final String CONSENT_ACTION_PARAMETER_NAME = "consent_action";
        private static final String CONSENT_ACTION_APPROVE = "approve";
        private static final String CONSENT_ACTION_CANCEL = "cancel";

        private UserConsentPage() {
        }

        private static void displayConsent(HttpServletRequest request, HttpServletResponse response, RegisteredClient registeredClient, OAuth2Authorization authorization) throws IOException {
            String consentPage = UserConsentPage.generateConsentPage(request, registeredClient, authorization);
            response.setContentType(TEXT_HTML_UTF8.toString());
            response.setContentLength(consentPage.getBytes(StandardCharsets.UTF_8).length);
            response.getWriter().write(consentPage);
        }

        private static boolean isConsentApproved(HttpServletRequest request) {
            return CONSENT_ACTION_APPROVE.equalsIgnoreCase(request.getParameter(CONSENT_ACTION_PARAMETER_NAME));
        }

        private static boolean isConsentCancelled(HttpServletRequest request) {
            return CONSENT_ACTION_CANCEL.equalsIgnoreCase(request.getParameter(CONSENT_ACTION_PARAMETER_NAME));
        }

        private static String generateConsentPage(HttpServletRequest request, RegisteredClient registeredClient, OAuth2Authorization authorization) {
            OAuth2AuthorizationRequest authorizationRequest = (OAuth2AuthorizationRequest)authorization.getAttribute(OAuth2AuthorizationRequest.class.getName());
            HashSet scopes = new HashSet(authorizationRequest.getScopes());
            scopes.remove("openid");
            String state = (String)authorization.getAttribute("state");
            StringBuilder builder = new StringBuilder();
            builder.append("<!DOCTYPE html>");
            builder.append("<html lang=\"en\">");
            builder.append("<head>");
            builder.append("    <meta charset=\"utf-8\">");
            builder.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">");
            builder.append("    <link rel=\"stylesheet\" href=\"https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css\" integrity=\"sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z\" crossorigin=\"anonymous\">");
            builder.append("    <title>Consent required</title>");
            builder.append("</head>");
            builder.append("<body>");
            builder.append("<div class=\"container\">");
            builder.append("    <div class=\"py-5\">");
            builder.append("        <h1 class=\"text-center\">Consent required</h1>");
            builder.append("    </div>");
            builder.append("    <div class=\"row\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <p><span class=\"font-weight-bold text-primary\">" + registeredClient.getClientId() + "</span> wants to access your account <span class=\"font-weight-bold\">" + authorization.getPrincipalName() + "</span></p>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("    <div class=\"row pb-3\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <p>The following permissions are requested by the above app.<br/>Please review these and consent if you approve.</p>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("    <div class=\"row\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <form method=\"post\" action=\"" + request.getRequestURI() + "\">");
            builder.append("                <input type=\"hidden\" name=\"client_id\" value=\"" + registeredClient.getClientId() + "\">");
            builder.append("                <input type=\"hidden\" name=\"state\" value=\"" + state + "\">");
            for (String scope : scopes) {
                builder.append("                <div class=\"form-group form-check py-1\">");
                builder.append("                    <input class=\"form-check-input\" type=\"checkbox\" name=\"scope\" value=\"" + scope + "\" id=\"" + scope + "\" checked>");
                builder.append("                    <label class=\"form-check-label\" for=\"" + scope + "\">" + scope + "</label>");
                builder.append("                </div>");
            }
            builder.append("                <div class=\"form-group pt-3\">");
            builder.append("                    <button class=\"btn btn-primary btn-lg\" type=\"submit\" name=\"consent_action\" value=\"approve\">Submit Consent</button>");
            builder.append("                </div>");
            builder.append("                <div class=\"form-group\">");
            builder.append("                    <button class=\"btn btn-link regular\" type=\"submit\" name=\"consent_action\" value=\"cancel\">Cancel</button>");
            builder.append("                </div>");
            builder.append("            </form>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("    <div class=\"row pt-4\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <p><small>Your consent to provide access is required.<br/>If you do not approve, click Cancel, in which case no information will be shared with the app.</small></p>");
            builder.append("        </div>");
            builder.append("    </div>");
            builder.append("</div>");
            builder.append("</body>");
            builder.append("</html>");
            return builder.toString();
        }
    }

    private static abstract class AbstractRequestContext {
        private final String authorizationUri;
        private final MultiValueMap<String, String> parameters;
        private final String clientId;
        private final String state;
        private final Set<String> scopes;
        private RegisteredClient registeredClient;
        private OAuth2Error error;
        private boolean redirectOnError;

        protected AbstractRequestContext(String authorizationUri, MultiValueMap<String, String> parameters, String clientId, String state, Set<String> scopes) {
            this.authorizationUri = authorizationUri;
            this.parameters = parameters;
            this.clientId = clientId;
            this.state = state;
            this.scopes = scopes;
        }

        protected String getAuthorizationUri() {
            return this.authorizationUri;
        }

        protected MultiValueMap<String, String> getParameters() {
            return this.parameters;
        }

        protected String getClientId() {
            return this.clientId;
        }

        protected String getState() {
            return this.state;
        }

        protected Set<String> getScopes() {
            return this.scopes;
        }

        protected RegisteredClient getRegisteredClient() {
            return this.registeredClient;
        }

        protected void setRegisteredClient(RegisteredClient registeredClient) {
            this.registeredClient = registeredClient;
        }

        protected OAuth2Error getError() {
            return this.error;
        }

        protected void setError(OAuth2Error error) {
            this.error = error;
        }

        protected boolean hasError() {
            return this.getError() != null;
        }

        protected boolean isRedirectOnError() {
            return this.redirectOnError;
        }

        protected void setRedirectOnError(boolean redirectOnError) {
            this.redirectOnError = redirectOnError;
        }

        protected abstract String resolveRedirectUri();
    }

    private static class UserConsentRequestContext
    extends AbstractRequestContext {
        private OAuth2Authorization authorization;

        private UserConsentRequestContext(String authorizationUri, MultiValueMap<String, String> parameters) {
            super(authorizationUri, parameters, (String)parameters.getFirst((Object)"client_id"), (String)parameters.getFirst((Object)"state"), UserConsentRequestContext.extractScopes(parameters));
        }

        private static Set<String> extractScopes(MultiValueMap<String, String> parameters) {
            List scope = (List)parameters.get((Object)"scope");
            return !CollectionUtils.isEmpty((Collection)scope) ? new HashSet(scope) : Collections.emptySet();
        }

        private OAuth2Authorization getAuthorization() {
            return this.authorization;
        }

        private void setAuthorization(OAuth2Authorization authorization) {
            this.authorization = authorization;
        }

        @Override
        protected String resolveRedirectUri() {
            OAuth2AuthorizationRequest authorizationRequest = this.getAuthorizationRequest();
            return StringUtils.hasText((String)authorizationRequest.getRedirectUri()) ? authorizationRequest.getRedirectUri() : this.getRegisteredClient().getRedirectUris().iterator().next();
        }

        private OAuth2AuthorizationRequest getAuthorizationRequest() {
            return (OAuth2AuthorizationRequest)this.getAuthorization().getAttribute(OAuth2AuthorizationRequest.class.getName());
        }
    }

    private static class OAuth2AuthorizationRequestContext
    extends AbstractRequestContext {
        private final String responseType;
        private final String redirectUri;

        private OAuth2AuthorizationRequestContext(String authorizationUri, MultiValueMap<String, String> parameters) {
            super(authorizationUri, parameters, (String)parameters.getFirst((Object)"client_id"), (String)parameters.getFirst((Object)"state"), OAuth2AuthorizationRequestContext.extractScopes(parameters));
            this.responseType = (String)parameters.getFirst((Object)"response_type");
            this.redirectUri = (String)parameters.getFirst((Object)"redirect_uri");
        }

        private static Set<String> extractScopes(MultiValueMap<String, String> parameters) {
            String scope = (String)parameters.getFirst((Object)"scope");
            return StringUtils.hasText((String)scope) ? new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" "))) : Collections.emptySet();
        }

        private String getResponseType() {
            return this.responseType;
        }

        private String getRedirectUri() {
            return this.redirectUri;
        }

        private boolean isAuthenticationRequest() {
            return this.getScopes().contains("openid");
        }

        @Override
        protected String resolveRedirectUri() {
            return StringUtils.hasText((String)this.getRedirectUri()) ? this.getRedirectUri() : this.getRegisteredClient().getRedirectUris().iterator().next();
        }

        private OAuth2AuthorizationRequest buildAuthorizationRequest() {
            return OAuth2AuthorizationRequest.authorizationCode().authorizationUri(this.getAuthorizationUri()).clientId(this.getClientId()).redirectUri(this.getRedirectUri()).scopes(this.getScopes()).state(this.getState()).additionalParameters(additionalParameters -> this.getParameters().entrySet().stream().filter(e -> !((String)e.getKey()).equals("response_type") && !((String)e.getKey()).equals("client_id") && !((String)e.getKey()).equals("redirect_uri") && !((String)e.getKey()).equals("scope") && !((String)e.getKey()).equals("state")).forEach(e -> additionalParameters.put(e.getKey(), ((List)e.getValue()).get(0)))).build();
        }
    }
}

