/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.Assert;

public final class DelegatingAuthenticationConverter
implements AuthenticationConverter {
    private final List<AuthenticationConverter> converters;

    public DelegatingAuthenticationConverter(List<AuthenticationConverter> converters) {
        Assert.notEmpty(converters, (String)"converters cannot be empty");
        this.converters = Collections.unmodifiableList(new LinkedList<AuthenticationConverter>(converters));
    }

    @Nullable
    public Authentication convert(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        return this.converters.stream().map(converter -> converter.convert(request)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

