/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.server.authorization.config.Settings;
import org.springframework.util.Assert;

public class TokenSettings
extends Settings {
    private static final String TOKEN_SETTING_BASE = "setting.token.";
    public static final String ACCESS_TOKEN_TIME_TO_LIVE = "setting.token.".concat("access-token-time-to-live");
    public static final String REUSE_REFRESH_TOKENS = "setting.token.".concat("reuse-refresh-tokens");
    public static final String REFRESH_TOKEN_TIME_TO_LIVE = "setting.token.".concat("refresh-token-time-to-live");

    public TokenSettings() {
        this(TokenSettings.defaultSettings());
    }

    public TokenSettings(Map<String, Object> settings) {
        super(settings);
    }

    public Duration accessTokenTimeToLive() {
        return (Duration)this.setting(ACCESS_TOKEN_TIME_TO_LIVE);
    }

    public TokenSettings accessTokenTimeToLive(Duration accessTokenTimeToLive) {
        Assert.notNull((Object)accessTokenTimeToLive, (String)"accessTokenTimeToLive cannot be null");
        Assert.isTrue((accessTokenTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"accessTokenTimeToLive must be greater than Duration.ZERO");
        this.setting(ACCESS_TOKEN_TIME_TO_LIVE, accessTokenTimeToLive);
        return this;
    }

    public boolean reuseRefreshTokens() {
        return (Boolean)this.setting(REUSE_REFRESH_TOKENS);
    }

    public TokenSettings reuseRefreshTokens(boolean reuseRefreshTokens) {
        this.setting(REUSE_REFRESH_TOKENS, reuseRefreshTokens);
        return this;
    }

    public Duration refreshTokenTimeToLive() {
        return (Duration)this.setting(REFRESH_TOKEN_TIME_TO_LIVE);
    }

    public TokenSettings refreshTokenTimeToLive(Duration refreshTokenTimeToLive) {
        Assert.notNull((Object)refreshTokenTimeToLive, (String)"refreshTokenTimeToLive cannot be null");
        Assert.isTrue((refreshTokenTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"refreshTokenTimeToLive must be greater than Duration.ZERO");
        this.setting(REFRESH_TOKEN_TIME_TO_LIVE, refreshTokenTimeToLive);
        return this;
    }

    protected static Map<String, Object> defaultSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put(ACCESS_TOKEN_TIME_TO_LIVE, Duration.ofMinutes(5L));
        settings.put(REUSE_REFRESH_TOKENS, true);
        settings.put(REFRESH_TOKEN_TIME_TO_LIVE, Duration.ofMinutes(60L));
        return settings;
    }
}

