/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.Version;
import org.springframework.util.Assert;

public class Settings
implements Serializable {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private final Map<String, Object> settings;

    public Settings() {
        this.settings = new HashMap<String, Object>();
    }

    public Settings(Map<String, Object> settings) {
        Assert.notNull(settings, (String)"settings cannot be null");
        this.settings = new HashMap<String, Object>(settings);
    }

    public <T> T setting(String name) {
        Assert.hasText((String)name, (String)"name cannot be empty");
        return (T)this.settings.get(name);
    }

    public <T extends Settings> T setting(String name, Object value) {
        Assert.hasText((String)name, (String)"name cannot be empty");
        Assert.notNull((Object)value, (String)"value cannot be null");
        this.settings.put(name, value);
        return (T)this;
    }

    public Map<String, Object> settings() {
        return this.settings;
    }

    public <T extends Settings> T settings(Consumer<Map<String, Object>> settingsConsumer) {
        settingsConsumer.accept(this.settings);
        return (T)this;
    }
}

