/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.server.authorization.config.Settings;

public class ProviderSettings
extends Settings {
    private static final String PROVIDER_SETTING_BASE = "setting.provider.";
    public static final String ISSUER = "setting.provider.".concat("issuer");
    public static final String AUTHORIZATION_ENDPOINT = "setting.provider.".concat("authorization-endpoint");
    public static final String TOKEN_ENDPOINT = "setting.provider.".concat("token-endpoint");
    public static final String JWK_SET_ENDPOINT = "setting.provider.".concat("jwk-set-endpoint");
    public static final String TOKEN_REVOCATION_ENDPOINT = "setting.provider.".concat("token-revocation-endpoint");

    public ProviderSettings() {
        this(ProviderSettings.defaultSettings());
    }

    public ProviderSettings(Map<String, Object> settings) {
        super(settings);
    }

    public String issuer() {
        return (String)this.setting(ISSUER);
    }

    public ProviderSettings issuer(String issuer) {
        return (ProviderSettings)this.setting(ISSUER, issuer);
    }

    public String authorizationEndpoint() {
        return (String)this.setting(AUTHORIZATION_ENDPOINT);
    }

    public ProviderSettings authorizationEndpoint(String authorizationEndpoint) {
        return (ProviderSettings)this.setting(AUTHORIZATION_ENDPOINT, authorizationEndpoint);
    }

    public String tokenEndpoint() {
        return (String)this.setting(TOKEN_ENDPOINT);
    }

    public ProviderSettings tokenEndpoint(String tokenEndpoint) {
        return (ProviderSettings)this.setting(TOKEN_ENDPOINT, tokenEndpoint);
    }

    public String jwkSetEndpoint() {
        return (String)this.setting(JWK_SET_ENDPOINT);
    }

    public ProviderSettings jwkSetEndpoint(String jwkSetEndpoint) {
        return (ProviderSettings)this.setting(JWK_SET_ENDPOINT, jwkSetEndpoint);
    }

    public String tokenRevocationEndpoint() {
        return (String)this.setting(TOKEN_REVOCATION_ENDPOINT);
    }

    public ProviderSettings tokenRevocationEndpoint(String tokenRevocationEndpoint) {
        return (ProviderSettings)this.setting(TOKEN_REVOCATION_ENDPOINT, tokenRevocationEndpoint);
    }

    protected static Map<String, Object> defaultSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put(AUTHORIZATION_ENDPOINT, "/oauth2/authorize");
        settings.put(TOKEN_ENDPOINT, "/oauth2/token");
        settings.put(JWK_SET_ENDPOINT, "/oauth2/jwks");
        settings.put(TOKEN_REVOCATION_ENDPOINT, "/oauth2/revoke");
        return settings;
    }
}

