/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.server.authorization.config.Settings;

public class ClientSettings
extends Settings {
    private static final String CLIENT_SETTING_BASE = "setting.client.";
    public static final String REQUIRE_PROOF_KEY = "setting.client.".concat("require-proof-key");
    public static final String REQUIRE_USER_CONSENT = "setting.client.".concat("require-user-consent");

    public ClientSettings() {
        this(ClientSettings.defaultSettings());
    }

    public ClientSettings(Map<String, Object> settings) {
        super(settings);
    }

    public boolean requireProofKey() {
        return (Boolean)this.setting(REQUIRE_PROOF_KEY);
    }

    public ClientSettings requireProofKey(boolean requireProofKey) {
        this.setting(REQUIRE_PROOF_KEY, requireProofKey);
        return this;
    }

    public boolean requireUserConsent() {
        return (Boolean)this.setting(REQUIRE_USER_CONSENT);
    }

    public ClientSettings requireUserConsent(boolean requireUserConsent) {
        this.setting(REQUIRE_USER_CONSENT, requireUserConsent);
        return this;
    }

    protected static Map<String, Object> defaultSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put(REQUIRE_PROOF_KEY, false);
        settings.put(REQUIRE_USER_CONSENT, false);
        return settings;
    }
}

