/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.client;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.Version;
import org.springframework.security.oauth2.server.authorization.config.ClientSettings;
import org.springframework.security.oauth2.server.authorization.config.TokenSettings;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RegisteredClient
implements Serializable {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private String id;
    private String clientId;
    private String clientSecret;
    private Set<ClientAuthenticationMethod> clientAuthenticationMethods;
    private Set<AuthorizationGrantType> authorizationGrantTypes;
    private Set<String> redirectUris;
    private Set<String> scopes;
    private ClientSettings clientSettings;
    private TokenSettings tokenSettings;

    protected RegisteredClient() {
    }

    public String getId() {
        return this.id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Set<ClientAuthenticationMethod> getClientAuthenticationMethods() {
        return this.clientAuthenticationMethods;
    }

    public Set<AuthorizationGrantType> getAuthorizationGrantTypes() {
        return this.authorizationGrantTypes;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public ClientSettings getClientSettings() {
        return this.clientSettings;
    }

    public TokenSettings getTokenSettings() {
        return this.tokenSettings;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisteredClient that = (RegisteredClient)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.clientAuthenticationMethods, that.clientAuthenticationMethods) && Objects.equals(this.authorizationGrantTypes, that.authorizationGrantTypes) && Objects.equals(this.redirectUris, that.redirectUris) && Objects.equals(this.scopes, that.scopes) && Objects.equals(this.clientSettings.settings(), that.getClientSettings().settings()) && Objects.equals(this.tokenSettings.settings(), that.tokenSettings.settings());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.clientId, this.clientSecret, this.clientAuthenticationMethods, this.authorizationGrantTypes, this.redirectUris, this.scopes, this.clientSettings.settings(), this.tokenSettings.settings());
    }

    public String toString() {
        return "RegisteredClient {id='" + this.id + '\'' + ", clientId='" + this.clientId + '\'' + ", clientAuthenticationMethods=" + this.clientAuthenticationMethods + ", authorizationGrantTypes=" + this.authorizationGrantTypes + ", redirectUris=" + this.redirectUris + ", scopes=" + this.scopes + ", clientSettings=" + this.clientSettings.settings() + ", tokenSettings=" + this.tokenSettings.settings() + '}';
    }

    public static Builder withId(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        return new Builder(id);
    }

    public static Builder from(RegisteredClient registeredClient) {
        Assert.notNull((Object)registeredClient, (String)"registeredClient cannot be null");
        return new Builder(registeredClient);
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
        private String id;
        private String clientId;
        private String clientSecret;
        private Set<ClientAuthenticationMethod> clientAuthenticationMethods = new HashSet<ClientAuthenticationMethod>();
        private Set<AuthorizationGrantType> authorizationGrantTypes = new HashSet<AuthorizationGrantType>();
        private Set<String> redirectUris = new HashSet<String>();
        private Set<String> scopes = new HashSet<String>();
        private ClientSettings clientSettings = new ClientSettings();
        private TokenSettings tokenSettings = new TokenSettings();

        protected Builder(String id) {
            this.id = id;
        }

        protected Builder(RegisteredClient registeredClient) {
            this.id = registeredClient.id;
            this.clientId = registeredClient.clientId;
            this.clientSecret = registeredClient.clientSecret;
            if (!CollectionUtils.isEmpty((Collection)registeredClient.clientAuthenticationMethods)) {
                this.clientAuthenticationMethods.addAll(registeredClient.clientAuthenticationMethods);
            }
            if (!CollectionUtils.isEmpty((Collection)registeredClient.authorizationGrantTypes)) {
                this.authorizationGrantTypes.addAll(registeredClient.authorizationGrantTypes);
            }
            if (!CollectionUtils.isEmpty((Collection)registeredClient.redirectUris)) {
                this.redirectUris.addAll(registeredClient.redirectUris);
            }
            if (!CollectionUtils.isEmpty((Collection)registeredClient.scopes)) {
                this.scopes.addAll(registeredClient.scopes);
            }
            this.clientSettings = new ClientSettings(registeredClient.clientSettings.settings());
            this.tokenSettings = new TokenSettings(registeredClient.tokenSettings.settings());
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder clientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
            this.clientAuthenticationMethods.add(clientAuthenticationMethod);
            return this;
        }

        public Builder clientAuthenticationMethods(Consumer<Set<ClientAuthenticationMethod>> clientAuthenticationMethodsConsumer) {
            clientAuthenticationMethodsConsumer.accept(this.clientAuthenticationMethods);
            return this;
        }

        public Builder authorizationGrantType(AuthorizationGrantType authorizationGrantType) {
            this.authorizationGrantTypes.add(authorizationGrantType);
            return this;
        }

        public Builder authorizationGrantTypes(Consumer<Set<AuthorizationGrantType>> authorizationGrantTypesConsumer) {
            authorizationGrantTypesConsumer.accept(this.authorizationGrantTypes);
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUris.add(redirectUri);
            return this;
        }

        public Builder redirectUris(Consumer<Set<String>> redirectUrisConsumer) {
            redirectUrisConsumer.accept(this.redirectUris);
            return this;
        }

        public Builder scope(String scope) {
            this.scopes.add(scope);
            return this;
        }

        public Builder scopes(Consumer<Set<String>> scopesConsumer) {
            scopesConsumer.accept(this.scopes);
            return this;
        }

        public Builder clientSettings(Consumer<ClientSettings> clientSettingsConsumer) {
            clientSettingsConsumer.accept(this.clientSettings);
            return this;
        }

        public Builder tokenSettings(Consumer<TokenSettings> tokenSettingsConsumer) {
            tokenSettingsConsumer.accept(this.tokenSettings);
            return this;
        }

        public RegisteredClient build() {
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            Assert.notEmpty(this.authorizationGrantTypes, (String)"authorizationGrantTypes cannot be empty");
            if (this.authorizationGrantTypes.contains(AuthorizationGrantType.AUTHORIZATION_CODE)) {
                Assert.notEmpty(this.redirectUris, (String)"redirectUris cannot be empty");
            }
            if (CollectionUtils.isEmpty(this.clientAuthenticationMethods)) {
                this.clientAuthenticationMethods.add(ClientAuthenticationMethod.BASIC);
            }
            this.validateScopes();
            this.validateRedirectUris();
            return this.create();
        }

        private RegisteredClient create() {
            RegisteredClient registeredClient = new RegisteredClient();
            registeredClient.id = this.id;
            registeredClient.clientId = this.clientId;
            registeredClient.clientSecret = this.clientSecret;
            registeredClient.clientAuthenticationMethods = Collections.unmodifiableSet(new HashSet<ClientAuthenticationMethod>(this.clientAuthenticationMethods));
            registeredClient.authorizationGrantTypes = Collections.unmodifiableSet(new HashSet<AuthorizationGrantType>(this.authorizationGrantTypes));
            registeredClient.redirectUris = Collections.unmodifiableSet(new HashSet<String>(this.redirectUris));
            registeredClient.scopes = Collections.unmodifiableSet(new HashSet<String>(this.scopes));
            registeredClient.clientSettings = new ClientSettings(this.clientSettings.settings());
            registeredClient.tokenSettings = new TokenSettings(this.tokenSettings.settings());
            return registeredClient;
        }

        private void validateScopes() {
            if (CollectionUtils.isEmpty(this.scopes)) {
                return;
            }
            for (String scope : this.scopes) {
                Assert.isTrue((boolean)Builder.validateScope(scope), (String)("scope \"" + scope + "\" contains invalid characters"));
            }
        }

        private static boolean validateScope(String scope) {
            return scope == null || scope.chars().allMatch(c -> Builder.withinTheRangeOf(c, 33, 33) || Builder.withinTheRangeOf(c, 35, 91) || Builder.withinTheRangeOf(c, 93, 126));
        }

        private static boolean withinTheRangeOf(int c, int min, int max) {
            return c >= min && c <= max;
        }

        private void validateRedirectUris() {
            if (CollectionUtils.isEmpty(this.redirectUris)) {
                return;
            }
            for (String redirectUri : this.redirectUris) {
                Assert.isTrue((boolean)Builder.validateRedirectUri(redirectUri), (String)("redirect_uri \"" + redirectUri + "\" is not a valid redirect URI or contains fragment"));
            }
        }

        private static boolean validateRedirectUri(String redirectUri) {
            try {
                URI validRedirectUri = new URI(redirectUri);
                return validRedirectUri.getFragment() == null;
            }
            catch (URISyntaxException ex) {
                return false;
            }
        }
    }
}

