/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.client;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;

public final class InMemoryRegisteredClientRepository
implements RegisteredClientRepository {
    private final Map<String, RegisteredClient> idRegistrationMap;
    private final Map<String, RegisteredClient> clientIdRegistrationMap;

    public InMemoryRegisteredClientRepository(RegisteredClient ... registrations) {
        this(Arrays.asList(registrations));
    }

    public InMemoryRegisteredClientRepository(List<RegisteredClient> registrations) {
        Assert.notEmpty(registrations, (String)"registrations cannot be empty");
        ConcurrentHashMap<String, RegisteredClient> idRegistrationMapResult = new ConcurrentHashMap<String, RegisteredClient>();
        ConcurrentHashMap<String, RegisteredClient> clientIdRegistrationMapResult = new ConcurrentHashMap<String, RegisteredClient>();
        for (RegisteredClient registration : registrations) {
            Assert.notNull((Object)registration, (String)"registration cannot be null");
            String id = registration.getId();
            if (idRegistrationMapResult.containsKey(id)) {
                throw new IllegalArgumentException("Registered client must be unique. Found duplicate identifier: " + id);
            }
            String clientId = registration.getClientId();
            if (clientIdRegistrationMapResult.containsKey(clientId)) {
                throw new IllegalArgumentException("Registered client must be unique. Found duplicate client identifier: " + clientId);
            }
            idRegistrationMapResult.put(id, registration);
            clientIdRegistrationMapResult.put(clientId, registration);
        }
        this.idRegistrationMap = idRegistrationMapResult;
        this.clientIdRegistrationMap = clientIdRegistrationMapResult;
    }

    @Override
    @Nullable
    public RegisteredClient findById(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        return this.idRegistrationMap.get(id);
    }

    @Override
    @Nullable
    public RegisteredClient findByClientId(String clientId) {
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        return this.clientIdRegistrationMap.get(clientId);
    }
}

