/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.Version;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public class OAuth2ClientAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private String clientId;
    private String clientSecret;
    private ClientAuthenticationMethod clientAuthenticationMethod;
    private Map<String, Object> additionalParameters;
    private RegisteredClient registeredClient;

    public OAuth2ClientAuthenticationToken(String clientId, String clientSecret, ClientAuthenticationMethod clientAuthenticationMethod, @Nullable Map<String, Object> additionalParameters) {
        this(clientId, additionalParameters);
        Assert.hasText((String)clientSecret, (String)"clientSecret cannot be empty");
        Assert.notNull((Object)clientAuthenticationMethod, (String)"clientAuthenticationMethod cannot be null");
        this.clientSecret = clientSecret;
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public OAuth2ClientAuthenticationToken(String clientId, @Nullable Map<String, Object> additionalParameters) {
        super(Collections.emptyList());
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        this.clientId = clientId;
        this.additionalParameters = additionalParameters != null ? Collections.unmodifiableMap(additionalParameters) : null;
        this.clientAuthenticationMethod = ClientAuthenticationMethod.NONE;
    }

    public OAuth2ClientAuthenticationToken(RegisteredClient registeredClient) {
        super(Collections.emptyList());
        Assert.notNull((Object)registeredClient, (String)"registeredClient cannot be null");
        this.registeredClient = registeredClient;
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.registeredClient != null ? this.registeredClient.getClientId() : this.clientId;
    }

    public Object getCredentials() {
        return this.clientSecret;
    }

    @Nullable
    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Nullable
    public RegisteredClient getRegisteredClient() {
        return this.registeredClient;
    }

    @Nullable
    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }
}

